package com.codingapi.springboot.framework.exception;

import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

import java.util.Locale;

class ExceptionLocaleMessage {

    private final MessageSource messageSource;

    public ExceptionLocaleMessage(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void init(){
        ExceptionMessageContext.getInstance().setExceptionLocaleMessage(this);
    }

    public String getMessage(String code){
        return this.getMessage(code,new Object[]{});
    }

    public String getMessage(String code,String defaultMessage){
        return this.getMessage(code,new Object[]{},defaultMessage);
    }

    public String getMessage(String code, String defaultMessage, Locale locale){
        return this.getMessage(code,new Object[]{},defaultMessage,locale);
    }

    public String getMessage(String code,Locale locale){
        return this.getMessage(code,new Object[]{},"",locale);
    }

    public String getMessage(String code,Object[] args){
        return this.getMessage(code,args,"");
    }

    public String getMessage(String code,Object[] args,Locale locale){
        return this.getMessage(code,args,"",locale);
    }

    public String getMessage(String code,Object[] args,String defaultMessage){
        Locale locale = LocaleContextHolder.getLocale();
        return this.getMessage(code,args, defaultMessage,locale);
    }

    public String getMessage(String code, Object[]args, String defaultMessage, Locale locale){
        return messageSource.getMessage(code,args, defaultMessage,locale);
    }
}
