package com.codota.service.client.requests.base;

import com.codota.service.client.CodotaConnectionException;
import com.codota.service.client.CodotaHttpException;
import com.codota.service.client.CodotaResponse;
import com.codota.service.connector.ServiceConnector;

import java.util.Map;

/**
 * Created by shaia on 28/05/2017.
 */
public abstract class PutRequest<T> extends Request {

    private String bodyJsonString;

    public PutRequest(ServiceConnector connector, String route, String token, Map<String, String> props) {
        super(connector, route, token);
        this.queryParameters = props;
    }

    public T run() throws CodotaConnectionException, CodotaHttpException {
        T result;
        CodotaResponse response = connector.put(this);
        if (response == null) {
            throw new CodotaConnectionException();
        }
        if (response.isOK()) {
            result = parse(response.content);
        } else {
            throw new CodotaHttpException(response.status, response.content);
        }
        return result;
    }

    public void withBodyJsonString(String bodyJsonString) {
        this.bodyJsonString = bodyJsonString;
    }

    public String getBodyJsonString() {
        return this.bodyJsonString;
    }

    public abstract T parse(String response);
}
