/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.model;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;

/**
 * Created by yahave on 3/1/15.
 * (C) Codota
 */
@SuppressWarnings("UnusedDeclaration")
public class UserInfo {
    public static final UserInfo UNKNOWN = new UserInfo();
    public String identifier;
    public String email;
    public String displayName;
    public String avatarUrl;
    public boolean hasTrackingAlias;
    public boolean justLoggedIn;
    public AccountInfo accountInfo;

    public List<String> getCodePacks() {
        if (accountInfo != null && accountInfo.packs != null)
            return accountInfo.packs;
        return Collections.emptyList();
    }

    @Nullable
    public String getDecryptURL() {
        if (accountInfo != null && accountInfo.decryptionUrl != null)
            return accountInfo.decryptionUrl;
        return null;
    }

    @Nullable
    public String getFirstPack() {
        if (accountInfo != null)
            return accountInfo.firstPack();
        else
            return null;
    }

    public String getAccountName() {
        if (accountInfo != null)
            return accountInfo.name;
        else
            return "";
    }

    @NotNull
    @SuppressWarnings("StringBufferReplaceableByString")
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(identifier);
        sb.append("\n");
        sb.append(email);
        sb.append("\n");
        sb.append(displayName);
        sb.append("\n");
        sb.append(avatarUrl);
        sb.append("\n");
        sb.append(hasTrackingAlias);
        sb.append("\n");
        sb.append(justLoggedIn);
        sb.append("\n");
        if (accountInfo != null)
            sb.append(accountInfo.toString());
        return sb.toString();
    }

}

