/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by yahave on 3/1/15.
 * (C) Codota
 */
@SuppressWarnings("UnusedDeclaration")
public class SearchStats {
    @NotNull
    final Map<String, Integer> stats;

    public SearchStats() {
        stats = new HashMap<String, Integer>();
    }

    public SearchStats(@NotNull StatsPair[] array) {
        stats = new HashMap<String, Integer>();
        for (StatsPair p : array) {
            try {
                stats.put(p.term, Integer.valueOf(p.numResults));
            } catch (NumberFormatException e) {
                // pass
            }

        }
    }

    public void putAll(@Nullable SearchStats other) {
        if (other != null) {
            stats.putAll(other.stats);
        }
    }

    public Integer get(String name) {
        return stats.get(name);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> me : stats.entrySet()) {
            sb.append(me.getKey());
            sb.append(":");
            sb.append(me.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    @SuppressWarnings("UnusedDeclaration")
    public class StatsPair {
        String term;
        String numResults;
    }

}
