/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client;

import org.jetbrains.annotations.NotNull;

@SuppressWarnings("UnusedDeclaration")
public class Token {
	public String methodKey;
	public String declaringClass;
	public String name;
	public int line;
	public int col;
	public int length;
	public int position;
	public String desc;
	public String classId;
	public String methodIndex;
	public String label;
	public String searchTerm;
	public String methodDocUrl;
	public boolean signatureMatch;
	public int apilevel;
	public boolean deprecated;
	public String type;

	
	@NotNull
	@Override
	public String toString() {
		return "Token [methodKey=" + methodKey + ", declaringClass="
				+ declaringClass + ", name=" + name + ", line=" + line
				+ ", col=" + col + ", length=" + length + ", position="
				+ position + ", desc=" + desc + ", classId=" + classId
				+ ", methodIndex=" + methodIndex + ", label=" + label
				+ ", searchTerm=" + searchTerm + ", methodDocUrl="
				+ methodDocUrl + ", signatureMatch=" + signatureMatch
				+ ", apilevel=" + apilevel + ", deprecated=" + deprecated
				+ ", type=" + type + "]";
	}
	
}
