/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client.requests;

import com.codota.service.client.SearchResults;
import com.codota.service.client.requests.base.GetRequest;
import com.codota.service.connector.ServiceConnector;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import org.jetbrains.annotations.NotNull;

/**
 * Created by yahave on 3/3/16.
 * (C) Codota
 */
public class SearchRequest extends GetRequest<SearchResults> {

    private static final String SEARCH_ROUTE = "/api/search?q=";

    public SearchRequest(ServiceConnector connector, String token, String query) {
        super(connector, connector.getBase() + SEARCH_ROUTE, token, query);
    }

    protected SearchRequest(ServiceConnector connector, String route,  String token, String query) {
        super(connector, route, token, query);
    }

    @Override
    public SearchResults parse(@NotNull String response) {
        SearchResults sr = SearchResults.EMPTY;
        try {
            JsonParser parser = new JsonParser();
            JsonElement root = parser.parse(response);
            sr = gson.fromJson(root, SearchResults.class);
        } catch (IllegalStateException e) {
            System.err.println("json" + response);
            e.printStackTrace();
        } catch (com.google.gson.JsonSyntaxException e) {
            System.err.println("json" + response);
            e.printStackTrace();
        }
        return sr;
    }
}
