/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client.requests;

import com.codota.service.client.requests.base.GetRequest;
import com.codota.service.connector.ServiceConnector;
import com.codota.service.model.XRefMethodItem;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by yahave on 3/3/16.
 * (C) Codota
 */
public class XRefMethodsRequest extends GetRequest<List<XRefMethodItem>> {

    /**
     * https://www.codota.com/api/completions/[codepack]/methods/[internal-class-name]?derived=false
     * <p>
     * [{"key":"Lcom/amazonaws/services/simpledb/model/RequestTimeoutException;<init>(Ljava/lang/String;)V","type":"METHOD","name":"<init>","signature":"(java.lang.String)"},
     * {"key":"Lcom/amazonaws/services/simpledb/model/RequestTimeoutException;getBoxUsage()Ljava/lang/Float;","type":"METHOD","name":"getBoxUsage","signature":"()"},
     * {"key":"Lcom/amazonaws/services/simpledb/model/RequestTimeoutException;setBoxUsage(Ljava/lang/Float;)V","type":"METHOD","name":"setBoxUsage","signature":"(java.lang.Float)"}]
     **/

    public XRefMethodsRequest(ServiceConnector connector, String route, Map<String, String> props, String token) {
        super(connector, route, "", props, token);
    }

    @Override
    public List<XRefMethodItem> parse(@NotNull String response) {

        List<XRefMethodItem> results = new ArrayList<XRefMethodItem>();
        JsonParser parser = new JsonParser();
        JsonArray array = parser.parse(response).getAsJsonArray();
        for (JsonElement o : array) {
            XRefMethodItem item = gson.fromJson(o, XRefMethodItem.class);
            results.add(item);
        }
        return results;
    }
}
