/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.model;

/**
 * Created by yahave on 2/23/16.
 * (C) Codota
 */

import org.jetbrains.annotations.NotNull;

/**
 "count": {
     "count": 3,
     "totalCount": 3,
     "precise": true,
     "max": false
 }
 */
public class BookmarkCount {
    public int count;
    public String totalCount;
    public boolean precise;
    public boolean max;

    @SuppressWarnings("StringBufferReplaceableByString")
    @NotNull
    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("BookmarkCount{");
        sb.append("count=").append(count);
        sb.append(", totalCount=").append(totalCount);
        sb.append(", precise=").append(precise);
        sb.append(", max=").append(max);
        sb.append('}');
        return sb.toString();
    }
}
