/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.model;

/**
 * Created by yahave on 2/23/16.
 * (C) Codota
 */

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

/**
 * "location": {
 * "length": 13,
 * "col": 18,
 * "line": 27,
 * "unitName": null
 * },
 */
public class Location implements Comparable<Location> {
    public int length;
    public int col;
    public int line;
    @Nullable
    public String unitName;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Location location = (Location) o;

        if (length != location.length) return false;
        if (col != location.col) return false;
        if (line != location.line) return false;
        return unitName != null ? unitName.equals(location.unitName) : location.unitName == null;

    }

    @Override
    public int hashCode() {
        int result = length;
        result = 31 * result + col;
        result = 31 * result + line;
        result = 31 * result + (unitName != null ? unitName.hashCode() : 0);
        return result;
    }

    public Location(@NotNull Map locMap) {
        Object mLength = locMap.get("length");
        Object mCol = locMap.get("col");
        Object mLine = locMap.get("line");
        Object mUnitName = locMap.get("unitName");

        if (mLength instanceof Double) {
            this.length = ((Double) mLength).intValue();
        }

        if (mCol instanceof Double) {
            this.col = ((Double) mCol).intValue();
        }
        if (mLine instanceof Double) {
            this.line = ((Double) mLine).intValue();
        }
        if (mUnitName != null && mUnitName instanceof String) {
            this.unitName = (String) mUnitName;
        }

    }

    @Override
    public int compareTo(Location other) {
        int unitCompareTo = 0;
        if (other == null) return 0;

        if (unitName != null && other.unitName != null) {
            unitCompareTo = unitName.compareTo(other.unitName);
        }
        // if it is not in the same unit, just return the unit ordering
        if (unitCompareTo != 0) return unitCompareTo;
        // otherwise, let's try the line numbers
        int lineDiff = line - other.line;
        if (lineDiff != 0) return lineDiff;
        int colDiff = col - other.col;
        return colDiff;
    }
}


