/*
 * Decompiled with CFR 0.152.
 */
package com.comparizen.client;

import com.cedarsoftware.io.JsonIo;
import com.comparizen.client.ComparisonProperties;
import com.comparizen.client.ComparizenClientException;
import com.comparizen.client.model.DiffConfig;
import com.comparizen.client.model.TestRunStatus;
import com.comparizen.client.model.TestRunStatusResponse;
import com.comparizen.client.util.HttpResponse;
import com.comparizen.client.util.HttpUtil;
import com.comparizen.client.util.ImageType;
import com.comparizen.client.util.UnknownMimeTypeException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class ComparizenClient {
    private static final String INVALID_JSON_ERROR_MESSAGE = "Received unexpected response from Comparizen server. Check your internet connection. If this problem persist, see the Comparizen website if there's a newer version of this client.";
    private final String DEFAULT_URL = "https://app.comparizen.com";
    private final String url;
    private final String apiKey;

    private ComparizenClient(String apiKey, String customURL) {
        this.apiKey = apiKey;
        this.url = customURL == null ? "https://app.comparizen.com" : customURL;
    }

    public String createTestRun(String projectId) throws ComparizenClientException {
        return this.createTestRun(projectId, null);
    }

    public String createTestRun(String projectId, String name) throws ComparizenClientException {
        return this.createTestRun(projectId, name, null);
    }

    public String createTestRun(String projectId, String name, Map<String, String> customEnvironmentProperties) throws ComparizenClientException {
        String action = "creating a test run";
        Map<String, String> environmentProperties = customEnvironmentProperties == null ? this.generateEnvironmentProperties() : customEnvironmentProperties;
        HashMap<String, Object> testRunProps = new HashMap<String, Object>();
        testRunProps.put("apiKey", this.apiKey);
        testRunProps.put("projectId", projectId);
        if (name != null) {
            testRunProps.put("name", name);
        }
        if (!environmentProperties.isEmpty()) {
            testRunProps.put("environmentProperties", environmentProperties);
        }
        try {
            HttpResponse response = HttpUtil.doPost(this.url + "/rest/testrun", JsonIo.toJson(testRunProps, null));
            this.verifyResponse(action, response);
            return this.getStringFromResponse(response, "id");
        }
        catch (IOException e) {
            throw this.generateConnectionErrorException(action, e);
        }
    }

    public void finalizeTestRun(String testRunId) throws ComparizenClientException {
        String action = "finalizing a test run";
        try {
            HttpResponse response = HttpUtil.doPost(this.url + "/rest/testrun/" + testRunId + "/finalize", "{\"apiKey\": \"" + this.apiKey + "\"}");
            this.verifyResponse(action, response);
        }
        catch (IOException e) {
            throw this.generateConnectionErrorException(action, e);
        }
    }

    public String createComparison(String testRunId, String name, Path file) throws ComparizenClientException {
        return this.performUpload(testRunId, name, file, null, null);
    }

    public String createComparison(String testRunId, String name, BufferedImage bufferedImage, ImageType imageType) throws ComparizenClientException {
        return this.performUpload(testRunId, name, bufferedImage, imageType, null);
    }

    public String createComparison(String testRunId, String name, Path file, ComparisonProperties properties) throws ComparizenClientException {
        return this.performUpload(testRunId, name, file, null, properties);
    }

    public String createComparison(String testRunId, String name, BufferedImage bufferedImage, ImageType imageType, ComparisonProperties properties) throws ComparizenClientException {
        return this.performUpload(testRunId, name, bufferedImage, imageType, properties);
    }

    private String performUpload(String testRunId, String name, Object bufferedImageOrPath, ImageType forcedImageType, ComparisonProperties properties) throws ComparizenClientException {
        String action = "uploading a screenshot";
        if (!(bufferedImageOrPath instanceof BufferedImage) && !(bufferedImageOrPath instanceof Path)) {
            throw new ComparizenClientException("Screenshot upload can only be done using a Path or BufferedImage object");
        }
        HashMap<String, Object> postParams = new HashMap<String, Object>();
        postParams.put("apiKey", this.apiKey);
        postParams.put("testRunId", testRunId);
        postParams.put("name", name);
        postParams.put("tags", this.extractCommaSeparatedTags(properties));
        postParams.put("excludeRegions", this.extractExcludeRegions(properties));
        postParams.put("file", bufferedImageOrPath);
        if (properties != null && properties.getDiffConfig() != null) {
            DiffConfig diffConfig = properties.getDiffConfig();
            if (diffConfig.getPerPixelThreshold() != null) {
                postParams.put("perPixelThreshold", diffConfig.getPerPixelThreshold());
            }
            if (diffConfig.getTotalDiffPercentageThreshold() != null) {
                postParams.put("totalDiffPercentageThreshold", diffConfig.getTotalDiffPercentageThreshold());
            }
        }
        try {
            HttpResponse response = HttpUtil.postMultipart(this.url + "/rest/comparison", postParams, forcedImageType);
            int responseStatusCode = response.getStatusCode();
            this.verifyResponse(action, response);
            return this.getStringFromResponse(response, "comparisonId");
        }
        catch (IOException e) {
            throw this.generateConnectionErrorException(action, e);
        }
        catch (UnknownMimeTypeException e) {
            throw new ComparizenClientException("Something went wrong while " + action + ": an invalid or unknown mime type was attached to the upload content: " + e.getMessage(), e);
        }
    }

    public TestRunStatusResponse getTestRunStatus(String testRunId) throws ComparizenClientException {
        String action = "retrieving test run status";
        try {
            HttpResponse response = HttpUtil.doGet(this.url + "/rest/testrun/" + testRunId + "/status?apiKey=" + this.apiKey);
            int responseStatusCode = response.getStatusCode();
            this.verifyResponse(action, response);
            Map responseMap = (Map)JsonIo.toObjects((String)response.getBody(), null, Map.class);
            if (responseMap == null || !responseMap.containsKey("status") || !responseMap.containsKey("url")) {
                throw new ComparizenClientException(INVALID_JSON_ERROR_MESSAGE);
            }
            return TestRunStatusResponse.builder().testRunStatus(TestRunStatus.fromString(String.valueOf(responseMap.get("status")))).url(String.valueOf(responseMap.get("url"))).build();
        }
        catch (IOException e) {
            throw this.generateConnectionErrorException(action, e);
        }
    }

    public TestRunStatusResponse waitUntilTestRunResult(String testRunId, long timeoutMs) throws ComparizenClientException, InterruptedException {
        long startTime = System.currentTimeMillis();
        while (startTime + timeoutMs >= System.currentTimeMillis()) {
            TestRunStatusResponse response = this.getTestRunStatus(testRunId);
            if (response.getTestRunStatus() != TestRunStatus.PROCESSING) {
                return response;
            }
            Thread.sleep(500L);
        }
        throw new ComparizenClientException("Test run with id " + testRunId + " was still processing after " + timeoutMs + " ms passed.");
    }

    private Map<String, String> generateEnvironmentProperties() {
        Map<String, String> env = System.getenv();
        if (env.containsKey("BITBUCKET_COMMIT")) {
            HashMap<String, String> envMap = new HashMap<String, String>();
            envMap.put("commitId", env.getOrDefault("BITBUCKET_COMMIT", null));
            envMap.put("bitBucketRepoSlug", env.getOrDefault("BITBUCKET_REPO_SLUG", null));
            envMap.put("bitBucketWorkspaceSlug", env.getOrDefault("BITBUCKET_WORKSPACE", null));
            return envMap;
        }
        return Collections.emptyMap();
    }

    private String extractCommaSeparatedTags(ComparisonProperties props) {
        if (props == null || props.getTagNames() == null) {
            return "";
        }
        return props.getTagNames().stream().map(t -> t.replaceAll(",", "")).collect(Collectors.joining(","));
    }

    private String extractExcludeRegions(ComparisonProperties props) {
        if (props == null || props.getExcludeRegions() == null) {
            return "";
        }
        return props.getExcludeRegions().stream().map(er -> String.format("%s %s %s %s", er.getX(), er.getY(), er.getWidth(), er.getHeight())).collect(Collectors.joining(","));
    }

    private String getStringFromResponse(HttpResponse response, String fieldKey) throws ComparizenClientException {
        try {
            Map responseMap = (Map)JsonIo.toObjects((String)response.getBody(), null, Map.class);
            if (responseMap == null || !responseMap.containsKey(fieldKey)) {
                throw new ComparizenClientException(INVALID_JSON_ERROR_MESSAGE);
            }
            return String.valueOf(responseMap.get(fieldKey));
        }
        catch (Exception e) {
            throw new ComparizenClientException(INVALID_JSON_ERROR_MESSAGE);
        }
    }

    private void verifyResponse(String action, HttpResponse response) throws ComparizenClientException {
        int statusCode = response.getStatusCode();
        if (statusCode < 400) {
            return;
        }
        ArrayList<String> messageLines = new ArrayList<String>();
        messageLines.add("Something went wrong while " + action + ".");
        String explainerText = "";
        if (statusCode == 400 || statusCode == 401 || statusCode == 403) {
            messageLines.add("Make sure your API key and project ID are correct and you're using the most recent version of the Comparizen Java Client. If this problem persist, please contact Comparizen support.");
        } else if (statusCode == 500) {
            messageLines.add("There might be a temporary problem with the Comparizen server. Please try again. If this problem persist, please contact Comparizen support.");
        }
        String statusCodeMessage = "Details: status code " + statusCode;
        String responseBody = response.getBody();
        if (responseBody != null && !responseBody.isEmpty()) {
            messageLines.add(statusCodeMessage + " - " + responseBody + ".");
        } else {
            messageLines.add(statusCodeMessage + ".");
        }
        throw new ComparizenClientException(String.join((CharSequence)" ", messageLines));
    }

    private ComparizenClientException generateConnectionErrorException(String action, Exception cause) {
        return new ComparizenClientException("Something went wrong while " + action + ": an exception occurred while communicating with the Comparizen server: " + cause.getMessage(), cause);
    }

    @Generated
    public static ComparizenClientBuilder builder() {
        return new ComparizenClientBuilder();
    }

    @Generated
    public static class ComparizenClientBuilder {
        @Generated
        private String apiKey;
        @Generated
        private String customURL;

        @Generated
        ComparizenClientBuilder() {
        }

        @Generated
        public ComparizenClientBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public ComparizenClientBuilder customURL(String customURL) {
            this.customURL = customURL;
            return this;
        }

        @Generated
        public ComparizenClient build() {
            return new ComparizenClient(this.apiKey, this.customURL);
        }

        @Generated
        public String toString() {
            return "ComparizenClient.ComparizenClientBuilder(apiKey=" + this.apiKey + ", customURL=" + this.customURL + ")";
        }
    }
}

