/*
 * Decompiled with CFR 0.152.
 */
package com.comparizen.client;

import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.JsonWriter;
import com.comparizen.client.ComparisonProperties;
import com.comparizen.client.ComparizenClientException;
import com.comparizen.client.model.TestRunStatus;
import com.comparizen.client.model.TestRunStatusResponse;
import com.comparizen.client.util.ImageType;
import com.comparizen.client.util.MultipartBodyPublisher;
import com.comparizen.client.util.UnknownMimeTypeException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

public class ComparizenClient {
    private static final String INVALID_JSON_ERROR_MESSAGE = "Received unexpected response from Comparizen server. Check your internet connection. If this problem persist, see the Comparizen website if there's a newer version of this client.";
    private final String DEFAULT_URL = "https://app.comparizen.com";
    private final HttpClient client;
    private final String url;
    private final String apiKey;

    private ComparizenClient(String apiKey, InetSocketAddress proxy, String customURL) {
        this.apiKey = apiKey;
        HttpClient.Builder builder = HttpClient.newBuilder();
        if (proxy != null) {
            builder.proxy(ProxySelector.of(proxy));
        }
        this.url = customURL == null ? "https://app.comparizen.com" : customURL;
        this.client = builder.build();
    }

    public String createTestRun(String projectId) throws ComparizenClientException {
        return this.createTestRun(projectId, null);
    }

    public String createTestRun(String projectId, String name) throws ComparizenClientException {
        return this.createTestRun(projectId, name, null);
    }

    public String createTestRun(String projectId, String name, Map<String, String> customEnvironmentProperties) throws ComparizenClientException {
        try {
            HttpRequest request;
            HttpResponse<String> response;
            int responseStatusCode;
            Map<String, String> environmentProperties = customEnvironmentProperties == null ? this.generateEnvironmentProperties() : customEnvironmentProperties;
            HashMap<String, Object> testRunProps = new HashMap<String, Object>();
            testRunProps.put("apiKey", this.apiKey);
            testRunProps.put("projectId", projectId);
            if (name != null) {
                testRunProps.put("name", name);
            }
            if (environmentProperties != null && !environmentProperties.isEmpty()) {
                testRunProps.put("environmentProperties", environmentProperties);
            }
            if ((responseStatusCode = (response = this.client.send(request = HttpRequest.newBuilder().uri(URI.create(this.url + "/rest/testrun")).POST(HttpRequest.BodyPublishers.ofString(JsonWriter.objectToJson(testRunProps))).header("Content-Type", "application/json").build(), HttpResponse.BodyHandlers.ofString())).statusCode()) >= 400) {
                throw new ComparizenClientException("Something went wrong while creating a test run: server responded with status code " + responseStatusCode + ": " + response.body());
            }
            return this.getStringFromResponse(response, "id");
        }
        catch (IOException | InterruptedException e) {
            throw new ComparizenClientException("Something went wrong while creating a test run: an exception occurred while communicating with the Comparizen server: " + e.getMessage(), e);
        }
    }

    public void finalizeTestRun(String testRunId) throws ComparizenClientException {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.url + "/rest/testrun/" + testRunId + "/finalize")).POST(HttpRequest.BodyPublishers.ofString("{\"apiKey\": \"" + this.apiKey + "\"}")).header("Content-Type", "application/json").build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            int responseStatusCode = response.statusCode();
            if (responseStatusCode >= 400) {
                throw new ComparizenClientException("Something went wrong while finalizing test run: server responded with status code " + responseStatusCode + ": " + response.body());
            }
        }
        catch (IOException | InterruptedException e) {
            throw new ComparizenClientException("Something went wrong while finalizing test run: an exception occurred while communicating with the Comparizen server: " + e.getMessage(), e);
        }
    }

    public String createComparison(String testRunId, String name, Path file) throws ComparizenClientException {
        return this.performUpload(testRunId, name, file, null, null);
    }

    public String createComparison(String testRunId, String name, BufferedImage bufferedImage, ImageType imageType) throws ComparizenClientException {
        return this.performUpload(testRunId, name, bufferedImage, imageType, null);
    }

    public String createComparison(String testRunId, String name, Path file, ComparisonProperties properties) throws ComparizenClientException {
        return this.performUpload(testRunId, name, file, null, properties);
    }

    public String createComparison(String testRunId, String name, BufferedImage bufferedImage, ImageType imageType, ComparisonProperties properties) throws ComparizenClientException {
        return this.performUpload(testRunId, name, bufferedImage, imageType, properties);
    }

    private String performUpload(String testRunId, String name, Object bufferedImageOrPath, ImageType forcedImageType, ComparisonProperties properties) throws ComparizenClientException {
        if (!(bufferedImageOrPath instanceof BufferedImage) && !(bufferedImageOrPath instanceof Path)) {
            throw new ComparizenClientException("Screenshot upload can only be done using a Path or BufferedImage object");
        }
        try {
            String boundary = "===imagecompare-upload-boundary-" + new BigInteger(256, new Random()).toString();
            Map<Object, Object> postParams = Map.of("apiKey", this.apiKey, "testRunId", testRunId, "name", name, "tags", this.extractCommaSeparatedTags(properties), "file", bufferedImageOrPath);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.url + "/rest/comparison")).header("Content-Type", "multipart/form-data;boundary=" + boundary).header("content-transfer-encoding", "binary").POST(MultipartBodyPublisher.ofMimeMultipartData(postParams, boundary, forcedImageType)).build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            int responseStatusCode = response.statusCode();
            if (responseStatusCode >= 400) {
                throw new ComparizenClientException("Something went wrong while uploading a screenshot: server responded with status code " + responseStatusCode + ": " + response.body());
            }
            return this.getStringFromResponse(response, "comparisonId");
        }
        catch (IOException | InterruptedException e) {
            throw new ComparizenClientException("Something went wrong while uploading a screenshot: an exception occurred while communicating with the Comparizen server: " + e.getMessage(), e);
        }
        catch (UnknownMimeTypeException e) {
            throw new ComparizenClientException("Something went wrong while uploading a screenshot: an invalid or unknown mime type was attached to the upload content: " + e.getMessage(), e);
        }
    }

    public TestRunStatusResponse getTestRunStatus(String testRunId) throws ComparizenClientException {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.url + "/rest/testrun/" + testRunId + "/status?apiKey=" + this.apiKey)).GET().build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            int responseStatusCode = response.statusCode();
            if (responseStatusCode >= 400) {
                throw new ComparizenClientException("Something went wrong while retrieving test run status: server responded with status code " + responseStatusCode + ": " + response.body());
            }
            Map responseMap = JsonReader.jsonToMaps((String)response.body());
            if (responseMap == null || !responseMap.containsKey("status") || !responseMap.containsKey("url")) {
                throw new ComparizenClientException(INVALID_JSON_ERROR_MESSAGE);
            }
            return TestRunStatusResponse.builder().testRunStatus(TestRunStatus.fromString(String.valueOf(responseMap.get("status")))).url(String.valueOf(responseMap.get("url"))).build();
        }
        catch (IOException | InterruptedException e) {
            throw new ComparizenClientException("Something went wrong while retrieving test run status: an exception occurred while communicating with the Comparizen server: " + e.getMessage(), e);
        }
    }

    public TestRunStatusResponse waitUntilTestRunResult(String testRunId, long timeoutMs) throws ComparizenClientException, InterruptedException {
        long startTime = System.currentTimeMillis();
        while (startTime + timeoutMs >= System.currentTimeMillis()) {
            TestRunStatusResponse response = this.getTestRunStatus(testRunId);
            if (response.getTestRunStatus() != TestRunStatus.PROCESSING) {
                return response;
            }
            Thread.sleep(500L);
        }
        throw new ComparizenClientException("Test run with id " + testRunId + " was still processing after " + timeoutMs + " ms passed.");
    }

    private Map<String, String> generateEnvironmentProperties() {
        Map<String, String> env = System.getenv();
        if (env.containsKey("BITBUCKET_COMMIT")) {
            return Map.of("commitId", env.getOrDefault("BITBUCKET_COMMIT", null), "bitBucketRepoSlug", env.getOrDefault("BITBUCKET_REPO_SLUG", null), "bitBucketWorkspaceSlug", env.getOrDefault("BITBUCKET_WORKSPACE", null));
        }
        return Collections.emptyMap();
    }

    private String extractCommaSeparatedTags(ComparisonProperties props) {
        if (props == null || props.getTagNames() == null) {
            return "";
        }
        return props.getTagNames().stream().map(t -> t.replaceAll(",", "")).collect(Collectors.joining(","));
    }

    private String getStringFromResponse(HttpResponse<String> response, String fieldKey) throws ComparizenClientException {
        try {
            Map responseMap = JsonReader.jsonToMaps((String)response.body());
            if (responseMap == null || !responseMap.containsKey(fieldKey)) {
                throw new ComparizenClientException(INVALID_JSON_ERROR_MESSAGE);
            }
            return String.valueOf(responseMap.get(fieldKey));
        }
        catch (Exception e) {
            throw new ComparizenClientException(INVALID_JSON_ERROR_MESSAGE);
        }
    }

    public static ComparizenClientBuilder builder() {
        return new ComparizenClientBuilder();
    }

    public static class ComparizenClientBuilder {
        private String apiKey;
        private InetSocketAddress proxy;
        private String customURL;

        ComparizenClientBuilder() {
        }

        public ComparizenClientBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public ComparizenClientBuilder proxy(InetSocketAddress proxy) {
            this.proxy = proxy;
            return this;
        }

        public ComparizenClientBuilder customURL(String customURL) {
            this.customURL = customURL;
            return this;
        }

        public ComparizenClient build() {
            return new ComparizenClient(this.apiKey, this.proxy, this.customURL);
        }

        public String toString() {
            return "ComparizenClient.ComparizenClientBuilder(apiKey=" + this.apiKey + ", proxy=" + this.proxy + ", customURL=" + this.customURL + ")";
        }
    }
}

