/*
 * Decompiled with CFR 0.152.
 */
package com.comparizen.client.util;

public class HttpResponse {
    int statusCode;
    String body;

    HttpResponse(int statusCode, String body) {
        this.statusCode = statusCode;
        this.body = body;
    }

    public static HttpResponseBuilder builder() {
        return new HttpResponseBuilder();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getBody() {
        return this.body;
    }

    public static class HttpResponseBuilder {
        private int statusCode;
        private String body;

        HttpResponseBuilder() {
        }

        public HttpResponseBuilder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public HttpResponseBuilder body(String body) {
            this.body = body;
            return this;
        }

        public HttpResponse build() {
            return new HttpResponse(this.statusCode, this.body);
        }

        public String toString() {
            return "HttpResponse.HttpResponseBuilder(statusCode=" + this.statusCode + ", body=" + this.body + ")";
        }
    }
}

