/*
 * Decompiled with CFR 0.152.
 */
package com.compdfkit.client;

import com.alibaba.fastjson.JSON;
import com.compdfkit.exception.CPDFException;
import com.compdfkit.param.CPDFFileParameter;
import com.compdfkit.pojo.comPdfKit.CPDFCreateTaskResult;
import com.compdfkit.pojo.comPdfKit.CPDFFileInfo;
import com.compdfkit.pojo.comPdfKit.CPDFOauthResult;
import com.compdfkit.pojo.comPdfKit.CPDFResult;
import com.compdfkit.pojo.comPdfKit.CPDFTaskInfoResult;
import com.compdfkit.pojo.comPdfKit.CPDFTaskRecordsResult;
import com.compdfkit.pojo.comPdfKit.CPDFTenantAssetResult;
import com.compdfkit.pojo.comPdfKit.CPDFTool;
import com.compdfkit.pojo.comPdfKit.CPDFUploadFileResult;
import com.compdfkit.utils.CPDFJsonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class CPDFHttpClient {
    private final RestTemplate restTemplate;
    private final Logger log = LoggerFactory.getLogger(CPDFHttpClient.class);
    private final String address;
    private long expireTime;
    private static String accessToken;
    private final String publicKey;
    private final String secretKey;

    CPDFHttpClient(RestTemplate restTemplate, String publicKey, String secretKey) {
        this.address = "https://api-server.compdf.com/server/";
        this.restTemplate = restTemplate;
        this.publicKey = publicKey;
        this.secretKey = secretKey;
        this.refreshAccessToken();
    }

    private HttpHeaders basicHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + this.getAccessToken());
        return headers;
    }

    String getAccessToken() {
        if (ObjectUtils.isEmpty((Object)this.expireTime) || System.currentTimeMillis() > this.expireTime) {
            this.refreshAccessToken();
        }
        return accessToken;
    }

    void setAccessToken(String token, long expiresIn) {
        accessToken = token;
        this.expireTime = System.currentTimeMillis() + expiresIn * 1000L;
    }

    void refreshAccessToken() {
        CPDFOauthResult newToken = this.getComPdfKitAuth(this.publicKey, this.secretKey);
        this.setAccessToken(newToken.getAccessToken(), Long.parseLong(newToken.getExpiresIn()));
    }

    CPDFOauthResult getComPdfKitAuth(String publicKey, String secretKey) {
        ResponseEntity responseEntity;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> tokenParam = new HashMap<String, String>();
        tokenParam.put("publicKey", publicKey);
        tokenParam.put("secretKey", secretKey);
        ParameterizedTypeReference<CPDFResult<CPDFOauthResult>> typeRef = new ParameterizedTypeReference<CPDFResult<CPDFOauthResult>>(){};
        try {
            responseEntity = this.restTemplate.exchange(this.address.concat("v1/oauth/token"), HttpMethod.POST, new HttpEntity((Object)CPDFJsonUtils.getJsonString(tokenParam), (MultiValueMap)headers), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Failed to get ComPDFKit Token: {}", (Object)e.getMessage());
            throw new CPDFException("Failed to get ComPDFKit Token: ");
        }
        if (responseEntity.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)responseEntity.getBody()) || !((CPDFResult)responseEntity.getBody()).getCode().equals("200")) {
            throw new CPDFException(((CPDFResult)Objects.requireNonNull(responseEntity.getBody())).getCode(), ((CPDFResult)responseEntity.getBody()).getMsg());
        }
        return (CPDFOauthResult)((CPDFResult)responseEntity.getBody()).getData();
    }

    List<CPDFTool> getTools() {
        ResponseEntity response;
        String url = this.address.concat("v1/tool/support");
        ParameterizedTypeReference<CPDFResult<List<CPDFTool>>> typeRef = new ParameterizedTypeReference<CPDFResult<List<CPDFTool>>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas query tools  failed: {}", (Object)e.getMessage());
            throw new CPDFException("Saas query tools  failed: " + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !((CPDFResult)response.getBody()).getCode().equals("200")) {
            throw new CPDFException(((CPDFResult)Objects.requireNonNull(response.getBody())).getCode(), ((CPDFResult)response.getBody()).getMsg());
        }
        return (List)((CPDFResult)response.getBody()).getData();
    }

    CPDFFileInfo getFileInfo(String fileKey, Integer language) {
        ResponseEntity response;
        String url = this.address.concat("v1/file/fileInfo").concat("?fileKey=").concat(fileKey);
        if (Objects.nonNull(language)) {
            url = url.concat("&language=").concat(String.valueOf(language));
        }
        ParameterizedTypeReference<CPDFResult<CPDFFileInfo>> typeRef = new ParameterizedTypeReference<CPDFResult<CPDFFileInfo>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas query file info failed: {}", (Object)e.getMessage());
            throw new CPDFException("Saas query file info failed: " + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !((CPDFResult)response.getBody()).getCode().equals("200")) {
            throw new CPDFException(((CPDFResult)Objects.requireNonNull(response.getBody())).getCode(), ((CPDFResult)response.getBody()).getMsg());
        }
        return (CPDFFileInfo)((CPDFResult)response.getBody()).getData();
    }

    CPDFTenantAssetResult getAssetInfo() {
        ResponseEntity response;
        String url = this.address.concat("v1/asset/info");
        ParameterizedTypeReference<CPDFResult<CPDFTenantAssetResult>> typeRef = new ParameterizedTypeReference<CPDFResult<CPDFTenantAssetResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas query tenant asset failed: {}", (Object)e.getMessage());
            throw new CPDFException("Saas query tenant asset failed: " + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !((CPDFResult)response.getBody()).getCode().equals("200")) {
            throw new CPDFException(((CPDFResult)Objects.requireNonNull(response.getBody())).getCode(), ((CPDFResult)response.getBody()).getMsg());
        }
        return (CPDFTenantAssetResult)((CPDFResult)response.getBody()).getData();
    }

    CPDFTaskRecordsResult getTaskList(String page, String size) {
        ResponseEntity response;
        if (StringUtils.isEmpty((Object)page)) {
            page = "1";
        }
        if (StringUtils.isEmpty((Object)size)) {
            size = "5";
        }
        String url = this.address.concat("v1/task/list").concat("?page=").concat(page).concat("&size=").concat(size);
        ParameterizedTypeReference<CPDFResult<CPDFTaskRecordsResult>> typeRef = new ParameterizedTypeReference<CPDFResult<CPDFTaskRecordsResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("{}", (Object)e.getMessage());
            throw new CPDFException("" + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !((CPDFResult)response.getBody()).getCode().equals("200")) {
            throw new CPDFException(((CPDFResult)Objects.requireNonNull(response.getBody())).getCode(), ((CPDFResult)response.getBody()).getMsg());
        }
        return (CPDFTaskRecordsResult)((CPDFResult)response.getBody()).getData();
    }

    CPDFCreateTaskResult createTask(String executeTypeUrl, Integer language) {
        ResponseEntity response;
        String url = this.address.concat("v1/task/{executeTypeUrl}").replace("{executeTypeUrl}", executeTypeUrl);
        if (Objects.nonNull(language)) {
            url = url.concat("&language=").concat(String.valueOf(language));
        }
        ParameterizedTypeReference<CPDFResult<CPDFCreateTaskResult>> typeRef = new ParameterizedTypeReference<CPDFResult<CPDFCreateTaskResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas task creation failed: {}", (Object)e.getMessage());
            throw new CPDFException("Saas task creation failed: " + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !((CPDFResult)response.getBody()).getCode().equals("200")) {
            throw new CPDFException(((CPDFResult)Objects.requireNonNull(response.getBody())).getCode(), ((CPDFResult)response.getBody()).getMsg());
        }
        return (CPDFCreateTaskResult)((CPDFResult)response.getBody()).getData();
    }

    CPDFUploadFileResult getUploadFileResult(File file, String taskId, String password, CPDFFileParameter fileParameter, Integer language) {
        try {
            return this.getUploadFileResult(new FileInputStream(file), taskId, password, fileParameter, file.getName(), null, null, language);
        }
        catch (FileNotFoundException e) {
            throw new CPDFException(e.getMessage(), e);
        }
    }

    CPDFUploadFileResult getUploadFileResult(final InputStream fileInputStream, String taskId, String password, CPDFFileParameter fileParameter, final String fileName, final InputStream imageInputStream, final String imageFileName, Integer language) {
        this.log.info("Start uploading files, task Id: {}, password: {}", (Object)taskId, (Object)password);
        String url = this.address.concat("v1/file/upload");
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        InputStreamResource inputStreamResource = new InputStreamResource(fileInputStream){

            public long contentLength() throws IOException {
                return fileInputStream.available();
            }

            public String getFilename() {
                return fileName;
            }
        };
        param.add((Object)"file", (Object)inputStreamResource);
        param.add((Object)"taskId", (Object)taskId);
        if (Objects.nonNull(language)) {
            param.add((Object)"language", (Object)language);
        }
        if (!StringUtils.isEmpty((Object)password)) {
            param.add((Object)"password", (Object)password);
        }
        if (!ObjectUtils.isEmpty((Object)fileParameter)) {
            param.add((Object)"parameter", (Object)JSON.toJSONString((Object)fileParameter));
        }
        if (!ObjectUtils.isEmpty((Object)imageInputStream) && !ObjectUtils.isEmpty((Object)imageFileName)) {
            InputStreamResource imageInputStreamResource = new InputStreamResource(imageInputStream){

                public long contentLength() throws IOException {
                    return imageInputStream.available();
                }

                public String getFilename() {
                    return imageFileName;
                }
            };
            param.add((Object)"image", (Object)imageInputStreamResource);
        }
        HttpHeaders headers = this.basicHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        ResponseEntity response = null;
        ParameterizedTypeReference<CPDFResult<CPDFUploadFileResult>> typeRef = new ParameterizedTypeReference<CPDFResult<CPDFUploadFileResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)param, (MultiValueMap)headers), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas upload file failed: {}", (Object)e.getMessage());
            throw new CPDFException("Saas upload file failed: " + e.getMessage());
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException e) {
                this.log.error("Failed to delete file; {}", (Object)e.getMessage());
            }
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !"200".equals(((CPDFResult)response.getBody()).getCode())) {
            throw new CPDFException(((CPDFResult)Objects.requireNonNull(response.getBody())).getCode(), ((CPDFResult)response.getBody()).getMsg());
        }
        return (CPDFUploadFileResult)((CPDFResult)response.getBody()).getData();
    }

    CPDFCreateTaskResult executeTask(String taskId, Integer language) {
        ResponseEntity response;
        this.log.info("Start executing task transfer, taskId: {}", (Object)taskId);
        String url = this.address.concat("v1/execute/start").concat("?taskId=").concat(taskId);
        if (Objects.nonNull(language)) {
            url = url.concat("&language=").concat(String.valueOf(language));
        }
        ParameterizedTypeReference<CPDFResult<CPDFCreateTaskResult>> result = new ParameterizedTypeReference<CPDFResult<CPDFCreateTaskResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((Object)CPDFJsonUtils.getJsonString(taskId), (MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)result, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas file conversion failed: {}", (Object)e.getMessage());
            throw new CPDFException("Saas file conversion failed: " + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !"200".equals(((CPDFResult)response.getBody()).getCode())) {
            throw new CPDFException(((CPDFResult)Objects.requireNonNull(response.getBody())).getCode(), ((CPDFResult)response.getBody()).getMsg());
        }
        return (CPDFCreateTaskResult)((CPDFResult)response.getBody()).getData();
    }

    CPDFTaskInfoResult getTaskInfo(String taskId, Integer language) {
        ResponseEntity response;
        this.log.info("Start to query the transfer status, taskId: {}", (Object)taskId);
        String url = this.address.concat("v1/task/taskInfo").concat("?taskId=").concat(taskId);
        if (Objects.nonNull(language)) {
            url = url.concat("&language=").concat(String.valueOf(language));
        }
        ParameterizedTypeReference<CPDFResult<CPDFTaskInfoResult>> result = new ParameterizedTypeReference<CPDFResult<CPDFTaskInfoResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((Object)CPDFJsonUtils.getJsonString(taskId), (MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)result, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Failed to query saas file status: {}", (Object)e.getMessage());
            throw new CPDFException("Failed to query saas file status: " + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !"200".equals(((CPDFResult)response.getBody()).getCode())) {
            throw new CPDFException(((CPDFResult)Objects.requireNonNull(response.getBody())).getCode(), ((CPDFResult)response.getBody()).getMsg());
        }
        this.log.info("Query status succeeded: {}", (Object)CPDFJsonUtils.getJsonString(((CPDFResult)response.getBody()).getData()));
        return (CPDFTaskInfoResult)((CPDFResult)response.getBody()).getData();
    }
}

