/*
 * Decompiled with CFR 0.152.
 */
package cn.kdan.compdfkit.client;

import cn.kdan.compdfkit.exception.BackendRuntimeException;
import cn.kdan.compdfkit.param.FileParameter;
import cn.kdan.compdfkit.pojo.comPdfKit.ComPdfKitOauthResult;
import cn.kdan.compdfkit.pojo.comPdfKit.ComPdfKitResult;
import cn.kdan.compdfkit.pojo.comPdfKit.CreateTaskResult;
import cn.kdan.compdfkit.pojo.comPdfKit.FileInfo;
import cn.kdan.compdfkit.pojo.comPdfKit.QueryTaskInfoResult;
import cn.kdan.compdfkit.pojo.comPdfKit.QueryTaskRecordsResult;
import cn.kdan.compdfkit.pojo.comPdfKit.QueryTenantAssetResult;
import cn.kdan.compdfkit.pojo.comPdfKit.Tool;
import cn.kdan.compdfkit.pojo.comPdfKit.UploadFileResult;
import cn.kdan.compdfkit.utils.JsonUtils;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class ComPdfKitClient {
    private static String accessToken;
    private static long expireTime;
    private final Logger log = LoggerFactory.getLogger(ComPdfKitClient.class);
    private final String publicKey;
    private final String secretKey;
    private final String address;
    private final RestTemplate restTemplate;

    public ComPdfKitClient(String publicKey, String secretKey) {
        this.address = "https://api-server.compdf.com/server/";
        this.publicKey = publicKey;
        this.secretKey = secretKey;
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        restTemplateBuilder.setReadTimeout(Duration.ofSeconds(300L));
        restTemplateBuilder.setConnectTimeout(Duration.ofSeconds(300L));
        restTemplateBuilder.setBufferRequestBody(false);
        this.restTemplate = restTemplateBuilder.build();
        this.refreshAccessToken();
    }

    public void setAccessToken(String token, long expiresIn) {
        accessToken = token;
        expireTime = System.currentTimeMillis() + expiresIn * 1000L;
    }

    public String getAccessToken() {
        if (ObjectUtils.isEmpty((Object)expireTime) || System.currentTimeMillis() > expireTime) {
            this.refreshAccessToken();
        }
        return accessToken;
    }

    private void refreshAccessToken() {
        ComPdfKitOauthResult newToken = this.getComPdfKitAuth(this.publicKey, this.secretKey);
        this.setAccessToken(newToken.getAccessToken(), Long.parseLong(newToken.getExpiresIn()));
    }

    private ComPdfKitOauthResult getComPdfKitAuth(String publicKey, String secretKey) {
        ResponseEntity responseEntity;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> tokenParam = new HashMap<String, String>();
        tokenParam.put("publicKey", publicKey);
        tokenParam.put("secretKey", secretKey);
        ParameterizedTypeReference<ComPdfKitResult<ComPdfKitOauthResult>> typeRef = new ParameterizedTypeReference<ComPdfKitResult<ComPdfKitOauthResult>>(){};
        try {
            responseEntity = this.restTemplate.exchange(this.address.concat("v1/oauth/token"), HttpMethod.POST, new HttpEntity((Object)JsonUtils.getJsonString(tokenParam), (MultiValueMap)headers), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Failed to get ComPDFKit Token{}", (Object)e.getMessage());
            throw new BackendRuntimeException("Failed to get ComPDFKit Token");
        }
        if (responseEntity.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)responseEntity.getBody()) || !((ComPdfKitResult)responseEntity.getBody()).getCode().equals("200")) {
            throw new BackendRuntimeException(Integer.valueOf(((ComPdfKitResult)responseEntity.getBody()).getCode()), ((ComPdfKitResult)responseEntity.getBody()).getMsg());
        }
        return (ComPdfKitOauthResult)((ComPdfKitResult)responseEntity.getBody()).getData();
    }

    private HttpHeaders basicHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + this.getAccessToken());
        return headers;
    }

    public List<Tool> queryTools() {
        ResponseEntity response;
        String url = this.address.concat("v1/tool/support");
        ParameterizedTypeReference<ComPdfKitResult<List<Tool>>> typeRef = new ParameterizedTypeReference<ComPdfKitResult<List<Tool>>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas query tools  failed{}", (Object)e.getMessage());
            throw new BackendRuntimeException("Saas query tools  failed" + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !((ComPdfKitResult)response.getBody()).getCode().equals("200")) {
            throw new BackendRuntimeException(Integer.valueOf(((ComPdfKitResult)response.getBody()).getCode()), ((ComPdfKitResult)response.getBody()).getMsg());
        }
        return (List)((ComPdfKitResult)response.getBody()).getData();
    }

    public FileInfo queryFileInfo(String fileKey) {
        ResponseEntity response;
        String url = this.address.concat("v1/tool/support").concat("?fileKey=").concat(fileKey);
        ParameterizedTypeReference<ComPdfKitResult<FileInfo>> typeRef = new ParameterizedTypeReference<ComPdfKitResult<FileInfo>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas query file info failed{}", (Object)e.getMessage());
            throw new BackendRuntimeException("Saas query file info failed" + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !((ComPdfKitResult)response.getBody()).getCode().equals("200")) {
            throw new BackendRuntimeException(Integer.valueOf(((ComPdfKitResult)response.getBody()).getCode()), ((ComPdfKitResult)response.getBody()).getMsg());
        }
        return (FileInfo)((ComPdfKitResult)response.getBody()).getData();
    }

    public QueryTenantAssetResult queryAssetInfo() {
        ResponseEntity response;
        String url = this.address.concat("v1/asset/info");
        ParameterizedTypeReference<ComPdfKitResult<QueryTenantAssetResult>> typeRef = new ParameterizedTypeReference<ComPdfKitResult<QueryTenantAssetResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas query tenant asset failed{}", (Object)e.getMessage());
            throw new BackendRuntimeException("Saas query tenant asset failed" + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !((ComPdfKitResult)response.getBody()).getCode().equals("200")) {
            throw new BackendRuntimeException(Integer.valueOf(((ComPdfKitResult)response.getBody()).getCode()), ((ComPdfKitResult)response.getBody()).getMsg());
        }
        return (QueryTenantAssetResult)((ComPdfKitResult)response.getBody()).getData();
    }

    public QueryTaskRecordsResult queryTaskList(String page, String size) {
        ResponseEntity response;
        if (StringUtils.isEmpty((Object)page)) {
            page = "1";
        }
        if (StringUtils.isEmpty((Object)size)) {
            size = "5";
        }
        String url = this.address.concat("v1/task/list").concat("?page=").concat(page).concat("&size=").concat(size);
        ParameterizedTypeReference<ComPdfKitResult<QueryTaskRecordsResult>> typeRef = new ParameterizedTypeReference<ComPdfKitResult<QueryTaskRecordsResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("{}", (Object)e.getMessage());
            throw new BackendRuntimeException("" + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !((ComPdfKitResult)response.getBody()).getCode().equals("200")) {
            throw new BackendRuntimeException(Integer.valueOf(((ComPdfKitResult)response.getBody()).getCode()), ((ComPdfKitResult)response.getBody()).getMsg());
        }
        return (QueryTaskRecordsResult)((ComPdfKitResult)response.getBody()).getData();
    }

    public CreateTaskResult createTask(String executeTypeUrl) {
        ResponseEntity response;
        String url = this.address.concat("v1/task/{executeTypeUrl}").replace("{executeTypeUrl}", executeTypeUrl);
        ParameterizedTypeReference<ComPdfKitResult<CreateTaskResult>> typeRef = new ParameterizedTypeReference<ComPdfKitResult<CreateTaskResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas task creation failed{}", (Object)e.getMessage());
            throw new BackendRuntimeException("Saas task creation failed" + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !((ComPdfKitResult)response.getBody()).getCode().equals("200")) {
            throw new BackendRuntimeException(Integer.valueOf(((ComPdfKitResult)response.getBody()).getCode()), ((ComPdfKitResult)response.getBody()).getMsg());
        }
        return (CreateTaskResult)((ComPdfKitResult)response.getBody()).getData();
    }

    public UploadFileResult uploadFile(File file, String taskId, String password) {
        return this.getUploadFileResult(file, taskId, password, null);
    }

    public UploadFileResult uploadFile(File file, String taskId) {
        return this.getUploadFileResult(file, taskId, null, null);
    }

    public UploadFileResult uploadFile(File file, String taskId, String password, FileParameter fileParameter) {
        return this.getUploadFileResult(file, taskId, password, fileParameter);
    }

    public UploadFileResult uploadFile(File file, String taskId, FileParameter fileParameter) {
        return this.getUploadFileResult(file, taskId, null, fileParameter);
    }

    private UploadFileResult getUploadFileResult(File file, String taskId, String password, FileParameter fileParameter) {
        this.log.info("Start uploading files, task Id: {}, password: {}", (Object)taskId, (Object)password);
        String url = this.address.concat("v1/file/upload");
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        FileSystemResource fs = new FileSystemResource(file);
        param.add((Object)"file", (Object)fs);
        param.add((Object)"taskId", (Object)taskId);
        if (!StringUtils.isEmpty((Object)password)) {
            param.add((Object)"password", (Object)password);
        }
        if (!ObjectUtils.isEmpty((Object)fileParameter)) {
            param.add((Object)"parameter", (Object)JSON.toJSONString((Object)fileParameter));
        }
        HttpHeaders headers = this.basicHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        ResponseEntity response = null;
        ParameterizedTypeReference<ComPdfKitResult<UploadFileResult>> typeRef = new ParameterizedTypeReference<ComPdfKitResult<UploadFileResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)param, (MultiValueMap)headers), (ParameterizedTypeReference)typeRef, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas upload file failed{}", (Object)e.getMessage());
            throw new BackendRuntimeException("Saas upload file failed" + e.getMessage());
        }
        finally {
            try {
                if (file.exists()) {
                    boolean bl = file.delete();
                }
            }
            catch (Exception e) {
                this.log.error("Failed to delete file; {}", (Object)e.getMessage());
            }
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !"200".equals(((ComPdfKitResult)response.getBody()).getCode())) {
            throw new BackendRuntimeException(Integer.valueOf(((ComPdfKitResult)response.getBody()).getCode()), ((ComPdfKitResult)response.getBody()).getMsg());
        }
        return (UploadFileResult)((ComPdfKitResult)response.getBody()).getData();
    }

    public CreateTaskResult executeTask(String taskId) {
        ResponseEntity response;
        this.log.info("Start executing task transfer, taskId: {}", (Object)taskId);
        String url = this.address.concat("v1/execute/start").concat("?taskId=").concat(taskId);
        ParameterizedTypeReference<ComPdfKitResult<CreateTaskResult>> result = new ParameterizedTypeReference<ComPdfKitResult<CreateTaskResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((Object)JsonUtils.getJsonString(taskId), (MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)result, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Saas file conversion failed{}", (Object)e.getMessage());
            throw new BackendRuntimeException("Saas file conversion failed" + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !"200".equals(((ComPdfKitResult)response.getBody()).getCode())) {
            throw new BackendRuntimeException(Integer.valueOf(((ComPdfKitResult)response.getBody()).getCode()), ((ComPdfKitResult)response.getBody()).getMsg());
        }
        return (CreateTaskResult)((ComPdfKitResult)response.getBody()).getData();
    }

    public QueryTaskInfoResult queryTaskInfo(String taskId) {
        ResponseEntity response;
        this.log.info("Start to query the transfer status, taskId: {}", (Object)taskId);
        String url = this.address.concat("v1/task/taskInfo").concat("?taskId=").concat(taskId);
        ParameterizedTypeReference<ComPdfKitResult<QueryTaskInfoResult>> result = new ParameterizedTypeReference<ComPdfKitResult<QueryTaskInfoResult>>(){};
        try {
            response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((Object)JsonUtils.getJsonString(taskId), (MultiValueMap)this.basicHeaders()), (ParameterizedTypeReference)result, new Object[0]);
        }
        catch (Exception e) {
            this.log.error("Failed to query saas file status{}", (Object)e.getMessage());
            throw new BackendRuntimeException("Failed to query saas file status" + e.getMessage());
        }
        if (response.getStatusCode() != HttpStatus.OK || ObjectUtils.isEmpty((Object)response.getBody()) || !"200".equals(((ComPdfKitResult)response.getBody()).getCode())) {
            throw new BackendRuntimeException(Integer.valueOf(((ComPdfKitResult)response.getBody()).getCode()), ((ComPdfKitResult)response.getBody()).getMsg());
        }
        this.log.info("Query status succeeded: {}", (Object)JsonUtils.getJsonString(((ComPdfKitResult)response.getBody()).getData()));
        return (QueryTaskInfoResult)((ComPdfKitResult)response.getBody()).getData();
    }
}

