/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import com.contentstack.sdk.ContentstackPlugin;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class Config {
    protected String livePreviewHash = null;
    protected String livePreviewContentType = null;
    protected String livePreviewEntryUid = null;
    protected String host = "cdn.contentstack.io";
    protected String version = "v3";
    protected String scheme = "https://";
    protected String endpoint;
    protected boolean enableLivePreview = false;
    protected String livePreviewHost;
    protected JSONObject livePreviewEntry = null;
    protected ContentstackRegion region = ContentstackRegion.US;
    protected String managementToken;
    protected String previewToken;
    protected String branch;
    protected Proxy proxy = null;
    protected String[] earlyAccess = null;
    protected ConnectionPool connectionPool = new ConnectionPool();
    protected List<ContentstackPlugin> plugins = null;

    public String[] getEarlyAccess() {
        return this.earlyAccess;
    }

    public Config setEarlyAccess(String[] earlyAccess) {
        this.earlyAccess = earlyAccess;
        return this;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public ConnectionPool connectionPool(int maxIdleConnections, long keepAliveDuration, TimeUnit timeUnit) {
        this.connectionPool = new ConnectionPool(maxIdleConnections, keepAliveDuration, timeUnit);
        return this.connectionPool;
    }

    public ContentstackRegion getRegion() {
        return this.region;
    }

    public ContentstackRegion setRegion(ContentstackRegion region) {
        this.region = region;
        return this.region;
    }

    protected String getEndpoint() {
        return this.endpoint + "/" + this.getVersion() + "/";
    }

    protected void setEndpoint(@NotNull String endpoint) {
        this.endpoint = endpoint;
    }

    public void setPlugins(List<ContentstackPlugin> plugins) {
        this.plugins = plugins;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String hostName) {
        if (hostName != null && !hostName.isEmpty()) {
            this.host = hostName;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public Config enableLivePreview(boolean enableLivePreview) {
        this.enableLivePreview = enableLivePreview;
        return this;
    }

    public Config setLivePreviewHost(@NotNull String livePreviewHost) {
        this.livePreviewHost = livePreviewHost;
        return this;
    }

    protected Config setLivePreviewEntry(@NotNull JSONObject livePreviewEntry) {
        this.livePreviewEntry = livePreviewEntry;
        return this;
    }

    public Config setPreviewToken(@NotNull String previewToken) {
        this.previewToken = previewToken;
        return this;
    }

    public Config setManagementToken(@NotNull String managementToken) {
        this.managementToken = managementToken;
        return this;
    }

    public static enum ContentstackRegion {
        US,
        EU,
        AZURE_NA,
        AZURE_EU,
        GCP_NA;

    }
}

