/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.json.JSONArray;
import org.json.JSONObject;

class AssetModel {
    String uploadedUid;
    String contentType;
    String fileSize;
    String fileName;
    String uploadUrl;
    String[] tags;
    JSONObject json;
    int count = 0;
    int totalCount = 0;

    public AssetModel(JSONObject response, boolean isArray) {
        this.json = isArray ? response : new JSONObject((Map)((LinkedHashMap)response.get("asset")));
        if (this.json != null) {
            this.uploadedUid = (String)this.json.opt("uid");
            this.contentType = (String)this.json.opt("content_type");
            this.fileSize = (String)this.json.opt("file_size");
            this.fileName = (String)this.json.opt("filename");
            this.uploadUrl = (String)this.json.opt("url");
            if (this.json.opt("tags") instanceof JSONArray) {
                this.extractTags();
            }
            if (response.has("count")) {
                this.count = response.optInt("count");
            }
            if (response.has("objects")) {
                this.totalCount = response.optInt("objects");
            }
        }
    }

    private void extractTags() {
        JSONArray tagsArray;
        JSONArray tagArray = this.json.optJSONArray("tags");
        if (tagArray != null && !tagArray.isEmpty() && (tagsArray = (JSONArray)this.json.opt("tags")).length() > 0) {
            int counter = tagsArray.length();
            this.tags = new String[counter];
            for (int i = 0; i < counter; ++i) {
                this.tags[i] = (String)tagsArray.opt(i);
            }
        }
    }

    @Generated
    public String getUploadedUid() {
        return this.uploadedUid;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public String getFileSize() {
        return this.fileSize;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public String getUploadUrl() {
        return this.uploadUrl;
    }

    @Generated
    public String[] getTags() {
        return this.tags;
    }

    @Generated
    public JSONObject getJson() {
        return this.json;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Generated
    public int getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public void setUploadedUid(String uploadedUid) {
        this.uploadedUid = uploadedUid;
    }

    @Generated
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Generated
    public void setFileSize(String fileSize) {
        this.fileSize = fileSize;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
    }

    @Generated
    public void setTags(String[] tags) {
        this.tags = tags;
    }

    @Generated
    public void setJson(JSONObject json) {
        this.json = json;
    }

    @Generated
    public void setCount(int count) {
        this.count = count;
    }

    @Generated
    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    @Generated
    public AssetModel() {
    }
}

