/*
 * Decompiled with CFR 0.152.
 */
package com.dataart.spreadsheetanalytics.engine;

import com.dataart.spreadsheetanalytics.api.engine.DataModelAccessor;
import com.dataart.spreadsheetanalytics.api.model.IDataModel;
import com.dataart.spreadsheetanalytics.api.model.IDataModelId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.cache.Cache;
import javax.cache.Caching;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheBasedDataModelAccessor
implements DataModelAccessor {
    private static final Logger log = LoggerFactory.getLogger(CacheBasedDataModelAccessor.class);
    public static final String DATA_MODEL_TO_ID_CACHE_NAME = "dataModelToIdCache";
    public static final String DATA_MODEL_TO_NAME_CACHE_NAME = "dataModelToNameCache";
    public static final String DATA_MODELS_FOR_EXECUTION_CACHE_NAME = "dataModelsForExecutionCache";
    protected Cache<IDataModelId, IDataModel> dataModelToIdCache = Caching.getCache((String)"dataModelToIdCache", IDataModelId.class, IDataModel.class);
    protected Cache<String, IDataModel> dataModelToNameCache = Caching.getCache((String)"dataModelToNameCache", String.class, IDataModel.class);

    @Override
    public void add(IDataModel dataModel) {
        this.dataModelToIdCache.put((Object)dataModel.getDataModelId(), (Object)dataModel);
        this.dataModelToNameCache.put((Object)dataModel.getName(), (Object)dataModel);
        log.debug("DataModel {} is added to DataModelStorage.", (Object)dataModel.getName());
    }

    @Override
    public void addAll(Collection<IDataModel> dataModels) {
        dataModels.forEach(dm -> {
            if (dm == null) {
                return;
            }
            this.dataModelToIdCache.put((Object)dm.getDataModelId(), dm);
            this.dataModelToNameCache.put((Object)dm.getName(), dm);
        });
        log.debug("DataModels {} are added to DataModelStorage.", dataModels.stream().map(Object::toString).collect(Collectors.toList()));
    }

    @Override
    public IDataModel get(IDataModelId dataModelId) {
        return (IDataModel)this.dataModelToIdCache.get((Object)dataModelId);
    }

    @Override
    public IDataModel get(String dataModelName) {
        return (IDataModel)this.dataModelToNameCache.get((Object)dataModelName);
    }

    @Override
    public Map<IDataModelId, IDataModel> getAll() {
        HashMap<Object, Object> dms = new HashMap<Object, Object>();
        for (Cache.Entry entry : this.dataModelToIdCache) {
            dms.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(dms);
    }

    public void setDataModelToIdCache(Cache<IDataModelId, IDataModel> dataModelToIdCache) {
        this.dataModelToIdCache = dataModelToIdCache;
    }

    public void setDataModelToNameCache(Cache<String, IDataModel> dataModelToNameCache) {
        this.dataModelToNameCache = dataModelToNameCache;
    }
}

