/*
 * Decompiled with CFR 0.152.
 */
package com.dataart.spreadsheetanalytics.engine;

import com.dataart.spreadsheetanalytics.api.engine.DataSetAccessor;
import com.dataart.spreadsheetanalytics.api.engine.ExternalServices;
import com.dataart.spreadsheetanalytics.api.model.IDataModelId;
import com.dataart.spreadsheetanalytics.api.model.IDataSet;
import com.dataart.spreadsheetanalytics.api.model.ILazyDataSet;
import com.dataart.spreadsheetanalytics.engine.CalculationEngineException;
import com.dataart.spreadsheetanalytics.engine.DataSetOptimisationsCache;
import com.dataart.spreadsheetanalytics.engine.DataSetScope;
import javax.cache.Cache;
import javax.cache.Caching;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheBasedDataSetAccessor
implements DataSetAccessor {
    private static final Logger log = LoggerFactory.getLogger(CacheBasedDataSetAccessor.class);
    public static final String DATA_SET_TO_ID_CACHE_NAME = "dataSetToIdCache";
    public static final String DATA_SET_TO_NAME_CACHE_NAME = "dataSetToNameCache";
    protected Cache<IDataModelId, IDataSet> dataSetToIdCache = Caching.getCache((String)"dataSetToIdCache", IDataModelId.class, IDataSet.class);
    protected Cache<String, IDataSet> dataSetToNameCache = Caching.getCache((String)"dataSetToNameCache", String.class, IDataSet.class);

    @Override
    public void add(IDataSet dataSet) {
        this.add(dataSet, DataSetScope.GLOBAL);
    }

    @Override
    public void add(IDataSet dataSet, DataSetScope scope) {
        if (dataSet == null) {
            return;
        }
        if (dataSet.getName() == null) {
            throw new CalculationEngineException("DataSet must have a name.");
        }
        switch (scope) {
            case LOCAL: {
                this.dataSetToNameCache.put((Object)dataSet.getName(), (Object)dataSet);
                this.dataSetToIdCache.put((Object)dataSet.getDataModelId(), (Object)dataSet);
                break;
            }
            default: {
                this.dataSetToNameCache.put((Object)dataSet.getName(), (Object)dataSet);
                this.dataSetToIdCache.put((Object)dataSet.getDataModelId(), (Object)dataSet);
            }
        }
        log.debug("Saved new DataSet {} with scope {} to DataSetStorage", (Object)dataSet.getName(), (Object)scope);
    }

    @Override
    public IDataSet get(IDataModelId dataModelId) {
        IDataSet dset = (IDataSet)this.dataSetToIdCache.get((Object)dataModelId);
        if (dset == null) {
            throw new CalculationEngineException(String.format("No DataSet with id = %s is found in DataSet storage.", dataModelId));
        }
        try {
            return this.isLazy(dset) ? ((ILazyDataSet)dset).get(ILazyDataSet.Parameters.EMPTY) : dset;
        }
        catch (Exception e) {
            throw new CalculationEngineException((Throwable)e);
        }
    }

    @Override
    public IDataSet get(String dataSetName) {
        return this.get(dataSetName, ILazyDataSet.Parameters.EMPTY);
    }

    @Override
    public IDataSet get(String dataSetName, ILazyDataSet.Parameters parameters) {
        DataSetOptimisationsCache optimisationsCaches = ExternalServices.INSTANCE.getDataSetOptimisationsCache();
        if (ILazyDataSet.Parameters.EMPTY != parameters && optimisationsCaches.dataSetToLazyParameters.containsKey((Object)parameters)) {
            return (IDataSet)optimisationsCaches.dataSetToLazyParameters.get((Object)parameters);
        }
        IDataSet dset = (IDataSet)this.dataSetToNameCache.get((Object)dataSetName);
        if (dset == null) {
            throw new CalculationEngineException(String.format("No DataSet with name = %s is found in DataSet storage.", dataSetName));
        }
        try {
            dset = this.isLazy(dset) ? ((ILazyDataSet)dset).get(parameters) : dset;
        }
        catch (Exception e) {
            throw new CalculationEngineException((Throwable)e);
        }
        if (ILazyDataSet.Parameters.EMPTY != parameters) {
            optimisationsCaches.dataSetToLazyParameters.put((Object)parameters, (Object)dset);
        }
        return dset;
    }

    @Override
    public boolean isLazy(String dataSetName) {
        return this.dataSetToNameCache.containsKey((Object)dataSetName) && this.dataSetToNameCache.get((Object)dataSetName) instanceof ILazyDataSet;
    }

    @Override
    public boolean isLazy(IDataSet dataSet) {
        return dataSet instanceof ILazyDataSet;
    }

    public void setDataSetToIdCache(Cache<IDataModelId, IDataSet> dataSetToIdCache) {
        this.dataSetToIdCache = dataSetToIdCache;
    }

    public void setDataSetToNameCache(Cache<String, IDataSet> dataSetToNameCache) {
        this.dataSetToNameCache = dataSetToNameCache;
    }
}

