/*
 * Decompiled with CFR 0.152.
 */
package com.dataart.spreadsheetanalytics.engine;

import com.dataart.spreadsheetanalytics.api.engine.DataSourceHub;
import com.dataart.spreadsheetanalytics.api.engine.datasource.DataSource;
import com.dataart.spreadsheetanalytics.api.engine.datasource.DataSourceQuery;
import com.dataart.spreadsheetanalytics.api.model.IDataSet;
import com.dataart.spreadsheetanalytics.engine.CalculationEngineException;
import java.util.List;
import javax.cache.Cache;
import javax.cache.Caching;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheBasedDataSourceHub
implements DataSourceHub {
    private static final Logger log = LoggerFactory.getLogger(CacheBasedDataSourceHub.class);
    public static final String DATA_SOURCE_CACHE_NAME = "dataSourceCache";
    protected Cache<Object, DataSource> dataSourceCache = Caching.getCache((String)"dataSourceCache", Object.class, DataSource.class);

    @Override
    public IDataSet executeQuery(String dataSourceName, DataSourceQuery query, List<Object> params) throws Exception {
        log.debug("Execute data query for DataSource: {} and Query: {}", (Object)dataSourceName, (Object)query);
        DataSource ds = this.get(dataSourceName);
        if (ds == null) {
            log.error(String.format("DataSource with name %s is not found.", dataSourceName));
            throw new CalculationEngineException(String.format("DataSource with name %s is not found.", dataSourceName));
        }
        return ds.executeQuery(query, params);
    }

    @Override
    public void add(DataSource sqlDataSource) {
        this.dataSourceCache.put((Object)(sqlDataSource.getName() == null ? "" : sqlDataSource.getName()), (Object)sqlDataSource);
        log.debug("Added DataSource with name {}", (Object)sqlDataSource.getName());
    }

    @Override
    public void remove(DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        this.dataSourceCache.remove((Object)(dataSource.getName() == null ? "" : dataSource.getName()));
    }

    @Override
    public void remove(String dataSourceName) {
        this.dataSourceCache.remove((Object)(dataSourceName == null ? "" : dataSourceName));
    }

    @Override
    public DataSource get(String dataSourceName) {
        return (DataSource)this.dataSourceCache.get((Object)(dataSourceName == null ? "" : dataSourceName));
    }

    public void setDataSourceCache(Cache<Object, DataSource> cache) {
        this.dataSourceCache = cache;
    }
}

