/*
 * Decompiled with CFR 0.152.
 */
package com.dataart.spreadsheetanalytics.engine.dataset;

import com.dataart.spreadsheetanalytics.api.engine.ExternalServices;
import com.dataart.spreadsheetanalytics.api.model.IDataSet;
import com.dataart.spreadsheetanalytics.api.model.IDsRow;
import com.dataart.spreadsheetanalytics.api.model.ILazyDataSet;
import com.dataart.spreadsheetanalytics.engine.CalculationEngineException;
import com.dataart.spreadsheetanalytics.engine.datasource.TextDataSourceQuery;
import com.dataart.spreadsheetanalytics.model.AbstractLazyDataSet;
import com.dataart.spreadsheetanalytics.model.DataSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SqlDataSet
extends AbstractLazyDataSet {
    protected String sql;
    protected String sqlDataSource;
    protected final Lock executionLock = new ReentrantLock();

    public SqlDataSet(String name, String sql, String sqlDataSource) {
        super(name);
        this.sql = sql;
        this.sqlDataSource = sqlDataSource;
    }

    public SqlDataSet(String name, String sql) {
        this(name, sql, null);
    }

    public IDataSet get(ILazyDataSet.Parameters parameters) throws Exception {
        try {
            this.executionLock.lock();
            this.dataSet = (DataSet)ExternalServices.INSTANCE.getDataSourceHub().executeQuery(this.sqlDataSource, new TextDataSourceQuery(this.sql), parameters.get());
            this.executed = Boolean.TRUE;
            DataSet dataSet = this.dataSet;
            return dataSet;
        }
        finally {
            this.executionLock.unlock();
        }
    }

    public IDsRow addRow() {
        throw new CalculationEngineException("Cannot add rows to SQL DataSet.");
    }

    public IDsRow addRow(int rowIdx) {
        throw new CalculationEngineException("Cannot add rows to SQL DataSet.");
    }

    public IDsRow getRow(int rowIdx) {
        return this.dataSet.getRow(rowIdx);
    }
}

