/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client;

import com.datasift.client.DataSiftClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.DataSiftResult;
import com.datasift.client.FutureData;
import com.datasift.client.FutureResponse;
import com.datasift.client.ParamBuilder;
import com.datasift.client.Response;
import io.higgs.core.func.Function2;
import io.higgs.http.client.Request;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;

public class DataSiftApiClient {
    protected DataSiftConfig config;

    public DataSiftApiClient(DataSiftConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be nulll");
        }
        this.config = config;
    }

    public Request applyConfig(Request request) {
        request.header("Authorization", this.config.authAsHeader());
        return request;
    }

    public ParamBuilder newParams() {
        return new ParamBuilder();
    }

    protected <T extends DataSiftResult> Function2<String, io.higgs.http.client.Response> newRequestCallback(final FutureData<T> future, final T instance) {
        return new Function2<String, io.higgs.http.client.Response>(){

            public void apply(String s, io.higgs.http.client.Response response) {
                DataSiftResult result = instance;
                if (response.getStatus() != null && HttpResponseStatus.NO_CONTENT.equals((Object)response.getStatus())) {
                    result.successful();
                } else if (response.hasFailed()) {
                    result.failed(response.failureCause());
                } else {
                    try {
                        result = (DataSiftResult)DataSiftClient.MAPPER.readValue(s, instance.getClass());
                    }
                    catch (IOException e) {
                        result.failed(e);
                    }
                }
                result.setResponse(new Response(s, response));
                future.received(result);
            }
        };
    }

    protected <T extends DataSiftResult, A extends DataSiftResult> void unwrapFuture(FutureData<T> futureToUnwrap, final FutureData<A> futureReturnedToUser, final A expectedInstance, final FutureResponse<T> responseToExecuteOnSuccess) {
        futureToUnwrap.onData(new FutureResponse<T>(){

            @Override
            public void apply(T stream) {
                if (((DataSiftResult)stream).isSuccessful()) {
                    responseToExecuteOnSuccess.apply(stream);
                } else {
                    expectedInstance.setResponse(((DataSiftResult)stream).getResponse());
                    futureReturnedToUser.received(expectedInstance);
                }
            }
        });
    }
}

