/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client;

import com.datasift.client.DataSiftConfig;
import com.datasift.client.core.DataSiftCore;
import com.datasift.client.historics.DataSiftHistorics;
import com.datasift.client.managedsource.DataSiftManagedSource;
import com.datasift.client.preview.DataSiftPreview;
import com.datasift.client.push.DataSiftPush;
import com.datasift.client.stream.StreamingData;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import io.higgs.http.client.HttpRequestBuilder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class DataSiftClient {
    public static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final int DEFAULT_NUM = Integer.MIN_VALUE;
    protected DataSiftConfig config;
    protected DataSiftHistorics historics;
    protected DataSiftManagedSource source;
    protected DataSiftCore core;
    protected DataSiftPreview preview;
    protected DataSiftPush push;
    protected StreamingData liveStream;

    public DataSiftClient() {
        this(new DataSiftConfig());
    }

    public DataSiftClient(DataSiftConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("DataSift config cannot be null");
        }
        this.configureMapper();
        this.config = config;
        this.historics = new DataSiftHistorics(config);
        this.source = new DataSiftManagedSource(config);
        this.core = new DataSiftCore(config);
        this.preview = new DataSiftPreview(config);
        this.push = new DataSiftPush(config);
        this.liveStream = new StreamingData(config);
    }

    protected void configureMapper() {
        MAPPER.setDateFormat((DateFormat)new SimpleDateFormat(DATE_FORMAT));
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.registerModule((Module)new JodaModule());
    }

    public DataSiftHistorics historics() {
        return this.historics;
    }

    public DataSiftManagedSource managedSource() {
        return this.source;
    }

    public DataSiftCore core() {
        return this.core;
    }

    public DataSiftPreview preview() {
        return this.preview;
    }

    public DataSiftPush push() {
        return this.push;
    }

    public DataSiftConfig config() {
        return this.config;
    }

    public StreamingData liveStream() {
        return this.liveStream;
    }

    public void shutdown() {
        HttpRequestBuilder.shutdown();
    }
}

