/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client;

import io.higgs.http.client.HttpRequestBuilder;
import java.net.URI;
import java.net.URISyntaxException;

public class DataSiftConfig {
    private static final String illConfigured = "(%s) is null, this is an ill-configured object and all API requests using it will fail";
    protected String proxyHost;
    protected int proxyPort;
    protected String username;
    protected String apiKey;
    protected boolean sslEnabled = true;
    protected String host = "api.datasift.com";
    protected HttpRequestBuilder http = HttpRequestBuilder.instance();
    private String versionPrefix = "v1.1";
    private String urlEncodingFormat = "ISO-8859-1";

    public DataSiftConfig() {
        this.http.userAgent("Mozilla/5.0 (compatible; Java Client/3.0.0; +https://github.com/datasift/datasift-java)");
    }

    public DataSiftConfig(String username, String apiKey) {
        this();
        this.auth(username, apiKey);
    }

    public DataSiftConfig auth(String username, String apiKey) {
        if (username == null || apiKey == null || username.isEmpty() || apiKey.isEmpty()) {
            throw new IllegalArgumentException(String.format("A valid username and API key are required. Username = %s, API key = %s", username, apiKey));
        }
        this.username = username;
        this.apiKey = apiKey;
        return this;
    }

    public String protocol() {
        return this.sslEnabled ? "https://" : "http://";
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.sslEnabled ? 443 : 80;
    }

    public URI baseURL() {
        StringBuilder b = new StringBuilder().append(this.protocol()).append(this.host()).append(":").append(this.port()).append("/").append(this.versionPrefix()).append("/");
        try {
            return new URI(b.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to construct a base URL for the API", e);
        }
    }

    public URI newAPIEndpointURI(String endpoint) {
        return this.baseURL().resolve(endpoint);
    }

    public URI newAPIEndpointURI(URI endpoint) {
        return this.baseURL().resolve(endpoint);
    }

    public String versionPrefix() {
        return this.versionPrefix;
    }

    public String getUsername() {
        if (this.username == null) {
            throw new IllegalStateException(String.format(illConfigured, "Username"));
        }
        return this.username;
    }

    public String getApiKey() {
        if (this.username == null) {
            throw new IllegalStateException(String.format(illConfigured, "API key"));
        }
        return this.apiKey;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public String authAsHeader() {
        return this.username + ":" + this.apiKey;
    }

    public HttpRequestBuilder http() {
        return this.http;
    }

    public String urlEncodingFormat() {
        return this.urlEncodingFormat;
    }

    public DataSiftConfig urlEncodingFormat(String format) {
        this.urlEncodingFormat = format;
        return this;
    }
}

