/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.core;

import com.datasift.client.DataSiftApiClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.FutureData;
import com.datasift.client.FutureResponse;
import com.datasift.client.core.Balance;
import com.datasift.client.core.Dpu;
import com.datasift.client.core.Stream;
import com.datasift.client.core.Usage;
import com.datasift.client.core.Validation;
import io.higgs.http.client.POST;
import io.higgs.http.client.Request;
import io.higgs.http.client.future.PageReader;
import io.higgs.http.client.future.Reader;
import java.net.URI;
import javax.validation.constraints.NotNull;

public class DataSiftCore
extends DataSiftApiClient {
    public final String VALIDATE = "validate";
    public final String COMPILE = "compile";
    public final String BALANCE = "balance";
    public final String DPU = "dpu";
    public final String USAGE = "usage";

    public DataSiftCore(DataSiftConfig config) {
        super(config);
    }

    public FutureData<Validation> validate(String csdl) {
        FutureData<Validation> future = new FutureData<Validation>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("validate"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new Validation()))).form("csdl", (Object)csdl);
        this.applyConfig((Request)request).execute();
        return future;
    }

    public FutureData<Stream> compile(String csdl) {
        FutureData<Stream> future = new FutureData<Stream>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("compile"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new Stream()))).form("csdl", (Object)csdl);
        this.applyConfig((Request)request).execute();
        return future;
    }

    public FutureData<Balance> balance() {
        FutureData<Balance> future = new FutureData<Balance>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("balance"));
        Request request = this.config.http().GET(uri, (Reader)new PageReader(this.newRequestCallback(future, new Balance())));
        this.applyConfig(request).execute();
        return future;
    }

    public FutureData<Dpu> dpu(@NotNull Stream stream) {
        return this.dpu(FutureData.wrap(stream));
    }

    public FutureData<Dpu> dpu(@NotNull FutureData<Stream> streamFuture) {
        final FutureData<Dpu> future = new FutureData<Dpu>();
        final Dpu dpu = new Dpu();
        FutureResponse<Stream> response = new FutureResponse<Stream>(){

            @Override
            public void apply(Stream stream) {
                URI uri = DataSiftCore.this.newParams().put("hash", stream.hash()).forURL(DataSiftCore.this.config.newAPIEndpointURI("dpu"));
                Request request = DataSiftCore.this.config.http().GET(uri, (Reader)new PageReader(DataSiftCore.this.newRequestCallback(future, dpu)));
                DataSiftCore.this.applyConfig(request).execute();
            }
        };
        this.unwrapFuture(streamFuture, future, dpu, response);
        return future;
    }

    public FutureData<Usage> usage() {
        return this.usage(Usage.Period.DAY);
    }

    public FutureData<Usage> usage(Usage.Period timePeriod) {
        String period;
        FutureData<Usage> future = new FutureData<Usage>();
        switch (timePeriod) {
            case HOUR: {
                period = "hour";
                break;
            }
            case CURRENT: {
                period = "current";
                break;
            }
            default: {
                period = "day";
            }
        }
        URI uri = this.newParams().put("period", period).forURL(this.config.newAPIEndpointURI("usage"));
        Request request = this.config.http().GET(uri, (Reader)new PageReader(this.newRequestCallback(future, new Usage())));
        this.applyConfig(request).execute();
        return future;
    }
}

