/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.examples;

import com.datasift.client.DataSiftClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.FutureData;
import com.datasift.client.FutureResponse;
import com.datasift.client.core.Dpu;
import com.datasift.client.core.Stream;
import com.datasift.client.core.Validation;
import com.datasift.client.stream.DataSiftMessage;
import com.datasift.client.stream.DeletedInteraction;
import com.datasift.client.stream.ErrorListener;
import com.datasift.client.stream.Interaction;
import com.datasift.client.stream.StreamEventListener;
import com.datasift.client.stream.StreamSubscription;

public class CoreApi {
    private CoreApi() {
    }

    public static void main(String ... args) throws InterruptedException {
        Object stream;
        DataSiftConfig config = new DataSiftConfig("username", "api-key");
        config = new DataSiftConfig().auth("zcourts", "44067e0ff342b76b52b36a63eea8e21a");
        DataSiftClient datasift = new DataSiftClient(config);
        String csdl = "interaction.content contains \"some string\"";
        Validation validation = datasift.core().validate(csdl).sync();
        if (validation.hasFailed()) {
            if (validation.failureCause() != null) {
                validation.failureCause().printStackTrace();
            }
            return;
        }
        System.out.println(validation);
        if (validation.isSuccessful()) {
            stream = datasift.core().compile(csdl);
            FutureData<Dpu> dpus = datasift.core().dpu((FutureData<Stream>)stream);
            dpus.onData(new FutureResponse<Dpu>(){

                @Override
                public void apply(Dpu data) {
                    System.out.println(data);
                }
            });
        }
        System.out.println(datasift.core().balance().sync());
        System.out.println(datasift.core().usage().sync());
        datasift.liveStream().onError(new ErrorListener(){

            @Override
            public void exceptionCaught(Throwable t) {
                t.printStackTrace();
            }
        });
        datasift.liveStream().onStreamEvent(new StreamEventListener(){

            @Override
            public void onDelete(DeletedInteraction di) {
                System.out.println("DELETED:\n " + di);
            }
        });
        stream = Stream.fromString("13e9347e7da32f19fcdb08e297019d2e");
        datasift.liveStream().subscribe(new StreamSubscription((Stream)stream){

            @Override
            public void onDataSiftLogMessage(DataSiftMessage di) {
                System.out.println((di.isError() ? "Error" : (di.isInfo() ? "Info" : "Warning")) + ":\n" + di);
            }

            @Override
            public void onMessage(Interaction i) {
                System.out.println("INTERACTION:\n" + i);
            }
        });
    }
}

