/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.push.connectors;

import com.datasift.client.push.OutputType;
import com.datasift.client.push.connectors.BaseConnector;

public class CouchDB
extends BaseConnector<CouchDB> {
    public CouchDB() {
        super(OutputType.COUCH_DB);
        this.setup(this, "host", "db_name", "auth.username", "auth.password");
    }

    public CouchDB url(String host, int port) {
        return this.host(host).port(port);
    }

    public CouchDB host(String host) {
        return (CouchDB)this.setParam("host", host);
    }

    public CouchDB port(int host) {
        return (CouchDB)this.setParam("port", String.valueOf(host));
    }

    public CouchDB dbName(String name) {
        return (CouchDB)this.setParam("db_name", name);
    }

    public CouchDB auth(String username, String password) {
        return this.username(username).password(password);
    }

    public CouchDB username(String username) {
        return (CouchDB)this.setParam("auth.username", username);
    }

    public CouchDB password(String password) {
        return (CouchDB)this.setParam("auth.password", password);
    }

    public CouchDB useSSL(String yesOrNo) {
        if (yesOrNo == null || !"yes".equals(yesOrNo) || !"no".equals(yesOrNo)) {
            throw new IllegalArgumentException("The strings yes or no are the only valid options for the use ssl option");
        }
        return (CouchDB)this.setParam("use_ssl", yesOrNo);
    }

    public CouchDB verifySSL(String yesOrNo) {
        if (yesOrNo == null || !"yes".equals(yesOrNo) || !"no".equals(yesOrNo)) {
            throw new IllegalArgumentException("The strings yes or no are the only valid options for the veirfy ssl option");
        }
        return (CouchDB)this.setParam("verify_ssl", yesOrNo);
    }

    public CouchDB format(CouchDBFormat format) {
        String strFormat;
        switch (format) {
            case FULL_INTERACTION_META: {
                strFormat = "full_interaction_meta";
                break;
            }
            default: {
                strFormat = "basic_interaction_meta";
            }
        }
        return (CouchDB)this.setParam("format", strFormat);
    }

    public static enum CouchDBFormat {
        BASIC_INTERACTION_META,
        FULL_INTERACTION_META;

    }
}

