/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.push.connectors;

import com.datasift.client.push.OutputType;
import com.datasift.client.push.connectors.BaseConnector;

public class MongoDB
extends BaseConnector<MongoDB> {
    public MongoDB() {
        super(OutputType.MONGO_DB);
        this.setup(this, "host", "db_name", "auth.username", "auth.password");
    }

    public MongoDB url(String host, int port) {
        return this.host(host).port(port);
    }

    public MongoDB host(String host) {
        return (MongoDB)this.setParam("host", host);
    }

    public MongoDB port(int host) {
        return (MongoDB)this.setParam("port", String.valueOf(host));
    }

    public MongoDB dbName(String name) {
        return (MongoDB)this.setParam("db_name", name);
    }

    public MongoDB collectionName(String name) {
        return (MongoDB)this.setParam("collection_name", name);
    }

    public MongoDB auth(String username, String password) {
        return this.username(username).password(password);
    }

    public MongoDB username(String username) {
        return (MongoDB)this.setParam("auth.username", username);
    }

    public MongoDB password(String password) {
        return (MongoDB)this.setParam("auth.password", password);
    }

    public MongoDB format(MongoDBFormat format) {
        String strFormat;
        switch (format) {
            case BASIC_INTERACTION_META: {
                strFormat = "basic_interaction_meta";
                break;
            }
            case FULL_INTERACTION_META_DATE: {
                strFormat = "full_interaction_meta_date";
                break;
            }
            default: {
                strFormat = "full_interaction_meta";
            }
        }
        return (MongoDB)this.setParam("format", strFormat);
    }

    public static enum MongoDBFormat {
        BASIC_INTERACTION_META,
        FULL_INTERACTION_META,
        FULL_INTERACTION_META_DATE;

    }
}

