/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.stream;

import com.datasift.client.DataSiftClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.core.Stream;
import com.datasift.client.stream.DataSiftMessage;
import com.datasift.client.stream.DeletedInteraction;
import com.datasift.client.stream.ErrorListener;
import com.datasift.client.stream.Interaction;
import com.datasift.client.stream.MultiStreamInteraction;
import com.datasift.client.stream.StreamEventListener;
import com.datasift.client.stream.StreamSubscription;
import io.higgs.core.func.Function1;
import io.higgs.events.Event;
import io.higgs.ws.client.WebSocketClient;
import io.higgs.ws.client.WebSocketEvent;
import io.higgs.ws.client.WebSocketMessage;
import io.higgs.ws.client.WebSocketStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.cliffc.high_scale_lib.NonBlockingHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingData {
    protected URI endpoint;
    protected WebSocketStream liveStream;
    protected DataSiftConfig config;
    protected Map<Stream, StreamSubscription> subscriptions = new NonBlockingHashMap();
    protected ErrorListener errorListener;
    protected StreamEventListener streamEventListener;
    protected boolean connected;
    protected Set<StreamSubscription> unsentSubscriptions = new NonBlockingHashSet();
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public StreamingData(DataSiftConfig config) {
        try {
            this.endpoint = new URI(String.format("ws://websocket.datasift.com:80/multi?username=%s&api_key=%s", config.getUsername(), config.getApiKey()));
        }
        catch (URISyntaxException e) {
            this.log.error("Unable to create endpoint URL", (Throwable)e);
        }
        this.config = config;
    }

    protected void connect() {
        if (this.liveStream == null) {
            this.liveStream = WebSocketClient.connect((URI)this.endpoint);
            this.liveStream.events().on((Function1)new Function1<WebSocketMessage>(){

                public void apply(WebSocketMessage frame) {
                    try {
                        MultiStreamInteraction mi = (MultiStreamInteraction)DataSiftClient.MAPPER.readValue(frame.data(), MultiStreamInteraction.class);
                        if (mi.isDataSiftMessage()) {
                            StreamingData.this.fireMessage(new DataSiftMessage(mi));
                        } else if (mi.getData().get("deleted") != null) {
                            StreamingData.this.streamEventListener.onDelete(new DeletedInteraction(mi));
                        } else {
                            StreamingData.this.fireInteraction(mi.getHash(), new Interaction(mi.getData()));
                        }
                    }
                    catch (IOException e) {
                        StreamingData.this.fireError(e);
                    }
                }
            }, new Event[]{WebSocketEvent.MESSAGE});
            this.liveStream.events().on((Function1)new Function1<Throwable>(){

                public void apply(Throwable t) {
                    if (t != null) {
                        StreamingData.this.fireError(t);
                    }
                }
            }, new Event[]{WebSocketEvent.ERROR});
            this.liveStream.events().on((Function1)new Function1<ChannelHandlerContext>(){

                public void apply(ChannelHandlerContext frame) {
                    StreamingData.this.streamEventListener.streamClosed();
                    StreamingData.this.connected = false;
                }
            }, new Event[]{WebSocketEvent.DISCONNECT});
            this.liveStream.events().on((Function1)new Function1<ChannelHandlerContext>(){

                public void apply(ChannelHandlerContext frame) {
                    StreamingData.this.streamEventListener.streamOpened();
                    StreamingData.this.connected = true;
                    StreamingData.this.pushUnsentSubscriptions();
                }
            }, new Event[]{WebSocketEvent.CONNECT});
        }
    }

    protected void fireInteraction(String hash, Interaction interaction) {
        for (Map.Entry<Stream, StreamSubscription> e : this.subscriptions.entrySet()) {
            if (!e.getKey().isSameAs(hash)) continue;
            e.getValue().onMessage(interaction);
        }
    }

    protected void fireMessage(DataSiftMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Message can't be null!");
        }
        for (Map.Entry<Stream, StreamSubscription> e : this.subscriptions.entrySet()) {
            if (message.hashHashes()) {
                for (Stream hash : message.hashes()) {
                    if (!e.getKey().isSameAs(hash)) continue;
                    e.getValue().onDataSiftLogMessage(message);
                }
                continue;
            }
            e.getValue().onDataSiftLogMessage(message);
        }
    }

    private void fireError(Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException("Error can't be null!");
        }
        this.errorListener.exceptionCaught(e);
    }

    public StreamingData onError(ErrorListener listener) {
        this.errorListener = listener;
        return this;
    }

    public void onStreamEvent(StreamEventListener streamEventListener) {
        this.streamEventListener = streamEventListener;
    }

    public StreamingData subscribe(StreamSubscription subscription) {
        if (this.errorListener == null) {
            throw new IllegalStateException("You must call listen before subscribing to streams otherwise you'll miss any exceptions that may occur");
        }
        if (this.streamEventListener == null) {
            throw new IllegalStateException("You must call onStreamEvent before subscribing to streams otherwise you'll miss delete messages, which you are required to handle");
        }
        this.connect();
        this.unsentSubscriptions.add(subscription);
        if (this.connected) {
            this.pushUnsentSubscriptions();
        }
        return this;
    }

    protected void pushUnsentSubscriptions() {
        for (final StreamSubscription subscription : this.unsentSubscriptions) {
            this.subscriptions.put(subscription.stream(), subscription);
            this.liveStream.emit("{\"action\":\"subscribe\",\"hash\":\"" + subscription.stream().hash() + "\"}").addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

                public void operationComplete(Future<Void> future) throws Exception {
                    if (future.isSuccess()) {
                        StreamingData.this.unsentSubscriptions.remove(subscription);
                    } else {
                        StreamingData.this.fireError(future.cause());
                        StreamingData.this.subscribe(subscription);
                    }
                }
            });
        }
    }

    public StreamingData unsubscribe(Stream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream can't be null");
        }
        if (stream.hash() == null || stream.hash().isEmpty()) {
            throw new IllegalArgumentException("Invalid stream subscription request, no hash available");
        }
        this.connect();
        this.liveStream.emit(" { \"action\" : \"unsubscribe\" , \"hash\": \"" + stream.hash() + "\"}");
        return this;
    }

    static {
        WebSocketClient.maxFramePayloadLength = 0x1400000;
    }
}

