/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client;

import com.datasift.client.DataSiftResult;
import com.datasift.client.FutureResponse;
import com.datasift.client.util.WrappedResponse;
import org.cliffc.high_scale_lib.NonBlockingHashSet;

public class FutureData<T> {
    protected NonBlockingHashSet<FutureResponse<T>> listeners = new NonBlockingHashSet();
    protected T data;

    public static <A extends DataSiftResult> FutureData<A> wrap(A obj) {
        if (obj == null) {
            throw new IllegalArgumentException("You cannot wrap null as future data");
        }
        FutureData future = new FutureData();
        obj.setResponse(new WrappedResponse());
        future.data = obj;
        return future;
    }

    public void received(T data) {
        this.data = data;
        this.notifyListeners();
        this.doNotify();
    }

    public FutureData<T> onData(FutureResponse<T> response) {
        this.listeners.add(response);
        if (this.data != null) {
            response.apply(this.data);
            this.doNotify();
        }
        return this;
    }

    protected void notifyListeners() {
        for (FutureResponse res : this.listeners) {
            res.apply(this.data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doNotify() {
        FutureData futureData = this;
        synchronized (futureData) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T sync() {
        if (this.data != null) {
            return this.data;
        }
        FutureData futureData = this;
        synchronized (futureData) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return this.data;
            }
        }
        return this.data;
    }
}

