/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.cli;

import com.datasift.client.DataSiftClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.DataSiftResult;
import com.datasift.client.cli.Parser;
import com.datasift.client.core.Stream;
import com.datasift.client.core.Usage;
import com.datasift.client.push.OutputType;
import com.datasift.client.push.connectors.BaseConnector;
import com.datasift.client.push.connectors.PushConnector;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.higgs.http.client.HttpRequestBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class Interface {
    private static final ObjectMapper mapper = new ObjectMapper();

    private Interface() {
    }

    public static void main(String[] args) {
        ArrayList<Parser.CliSwitch> switches = new ArrayList<Parser.CliSwitch>();
        switches.add(new Parser.CliSwitch("a", "auth", true, "Auth is required in the form username:api_key"));
        switches.add(new Parser.CliSwitch("c", "command", true));
        Parser.CliSwitch endpoint = new Parser.CliSwitch("e", "endpoint");
        endpoint.setDefault("core");
        switches.add(endpoint);
        switches.add(new Parser.CliSwitch("p", "param"));
        Parser.CliArguments parsedArgs = Parser.parse(args, switches);
        HashMap<String, String> auth = parsedArgs.map("a");
        if (auth == null || auth.size() == 0) {
            System.out.println("Auth must be provided in the form '-a[uth] username api_key'");
            System.exit(0);
        }
        Map.Entry authVals = auth.entrySet().iterator().next();
        DataSiftConfig config = new DataSiftConfig((String)authVals.getKey(), (String)authVals.getValue());
        DataSiftClient dataSift = new DataSiftClient(config);
        switch (parsedArgs.get("e")) {
            case "core": {
                Interface.executeCore(dataSift, parsedArgs.get("c"), parsedArgs.map("p"));
                break;
            }
            case "push": {
                Interface.executePush(dataSift, parsedArgs.get("c"), parsedArgs.map("p"));
                break;
            }
            case "historics": {
                Interface.executeHistorics(dataSift, parsedArgs.get("c"), parsedArgs.map("p"));
                break;
            }
            case "preview": {
                Interface.executePreview(dataSift, parsedArgs.get("c"), parsedArgs.map("p"));
                break;
            }
            case "sources": {
                Interface.executeSources(dataSift, parsedArgs.get("c"), parsedArgs.map("p"));
            }
        }
        HttpRequestBuilder.shutdown();
    }

    private static void require(String[] args, Map<String, String> params) {
        ArrayList<String> missing = new ArrayList<String>();
        for (String arg : args) {
            if (params.containsKey(arg)) continue;
            missing.add(arg);
        }
        if (missing.size() > 0) {
            System.out.println("The following arguments are required : " + Arrays.toString(missing.toArray()));
            System.exit(0);
        }
    }

    private static void executeCore(DataSiftClient dataSift, String endpoint, Map<String, String> params) {
        switch (endpoint) {
            case "validate": {
                Interface.require(new String[]{"csdl"}, params);
                Interface.printResponse(dataSift.validate(params.get("csdl")).sync());
                break;
            }
            case "compile": {
                Interface.require(new String[]{"csdl"}, params);
                Interface.printResponse(dataSift.compile(params.get("csdl")).sync());
                break;
            }
            case "usage": {
                String period = params.get("period");
                if (period == null) {
                    Interface.printResponse(dataSift.usage().sync());
                    break;
                }
                Interface.printResponse(dataSift.usage(Usage.Period.fromStr(period)).sync());
                break;
            }
            case "dpu": {
                Interface.require(new String[]{"hash"}, params);
                Interface.printResponse(dataSift.dpu(Stream.fromString(params.get("hash"))).sync());
                break;
            }
            case "balance": {
                Interface.printResponse(dataSift.balance().sync());
            }
        }
    }

    private static void printResponse(DataSiftResult result) {
        int status = result.getResponse().status();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> h : result.getResponse().headers().entrySet()) {
            headers.put(h.getKey(), h.getValue() == null || h.getValue().size() == 0 ? null : h.getValue().get(0));
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("body", result.getResponse().data());
        response.put("status", status);
        response.put("headers", headers);
        try {
            System.out.println(mapper.writeValueAsString(response));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private static void executePush(DataSiftClient dataSift, String endpoint, HashMap<String, String> params) {
        PushConnector connector = null;
        try {
            Map args = (Map)mapper.readValue(params.get("output_type"), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            connector = BaseConnector.fromMap(new OutputType<PushConnector>(params.get("output_type")), args);
        }
        catch (IOException e) {
            System.out.println("output_type must be a valid JSON object received : " + params.get("output_type"));
            System.exit(0);
        }
        switch (endpoint) {
            case "validate": {
                Interface.printResponse(dataSift.push().validate(connector).sync());
                break;
            }
            case "create": {
                Interface.printResponse(dataSift.push().create(connector, Stream.fromString(params.get("hash")), params.get("name")).sync());
                break;
            }
            case "pause": {
                Interface.printResponse(dataSift.push().pause(params.get("id")).sync());
                break;
            }
            case "resume": {
                Interface.printResponse(dataSift.push().resume(params.get("id")).sync());
                break;
            }
            case "update": {
                Interface.printResponse(dataSift.push().update(params.get("id"), connector).sync());
                break;
            }
            case "stop": {
                Interface.printResponse(dataSift.push().stop(params.get("id")).sync());
                break;
            }
            case "delete": {
                Interface.printResponse(dataSift.push().delete(params.get("id")).sync());
                break;
            }
            case "log": {
                try {
                    Interface.printResponse(dataSift.push().log(params.get("id"), Integer.parseInt(params.get("page"))).sync());
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
                break;
            }
            case "get": {
                Interface.printResponse(dataSift.push().get(params.get("id")).sync());
                break;
            }
            case "pull": {
                try {
                    Interface.printResponse(dataSift.push().pull(params.get("id"), Integer.parseInt(params.get("size")), params.get("page")).sync());
                    break;
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
            }
        }
    }

    private static void executeHistorics(DataSiftClient dataSift, String endpoint, HashMap<String, String> params) {
        switch (endpoint) {
            case "prepare": {
                Interface.printResponse(dataSift.historics().prepare(params.get("hash"), DateTime.parse((String)params.get("start")), DateTime.parse((String)params.get("end")), params.get("name")).sync());
                break;
            }
            case "start": {
                Interface.printResponse(dataSift.historics().start(params.get("id")).sync());
                break;
            }
            case "stop": {
                Interface.printResponse(dataSift.historics().stop(params.get("id"), params.get("reason")).sync());
                break;
            }
            case "status": {
                Interface.printResponse(dataSift.historics().status(new DateTime(Long.parseLong(params.get("start"))), new DateTime(Long.parseLong(params.get("end"))), new String[0]).sync());
                break;
            }
            case "update": {
                Interface.printResponse(dataSift.historics().update(params.get("id"), params.get("name")).sync());
                break;
            }
            case "delete": {
                Interface.printResponse(dataSift.historics().delete(params.get("id")).sync());
                break;
            }
            case "get": {
                Interface.printResponse(dataSift.historics().get(params.get("id")).sync());
            }
        }
    }

    private static void executePreview(DataSiftClient dataSift, String endpoint, HashMap<String, String> params) {
        switch (endpoint) {
            case "create": {
                Interface.printResponse(dataSift.preview().create(new DateTime(Long.parseLong(params.get("start"))), Stream.fromString(params.get("hash")), params.get("params").split(",")).sync());
                break;
            }
            case "get": {
                Interface.printResponse(dataSift.preview().get(params.get("id")).sync());
            }
        }
    }

    private static void executeSources(DataSiftClient dataSift, String endpoint, HashMap<String, String> params) {
        switch (endpoint) {
            case "create": {
                break;
            }
            case "update": {
                break;
            }
            case "delete": {
                Interface.printResponse(dataSift.managedSource().delete(params.get("id")).sync());
                break;
            }
            case "log": {
                Interface.printResponse(dataSift.managedSource().log(params.get("id")).sync());
                break;
            }
            case "get": {
                Interface.printResponse(dataSift.managedSource().get(params.get("id")).sync());
                break;
            }
            case "stop": {
                Interface.printResponse(dataSift.managedSource().stop(params.get("id")).sync());
                break;
            }
            case "start": {
                Interface.printResponse(dataSift.managedSource().start(params.get("id")).sync());
            }
        }
    }
}

