/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.historics;

import com.datasift.client.DataSiftResult;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public class HistoricsQuery
extends DataSiftResult {
    @JsonProperty
    private String id;
    @JsonProperty(value="definition_id")
    private String definitationId;
    @JsonProperty
    private String name;
    @JsonProperty
    private long start;
    @JsonProperty
    private long end;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty
    private String status;
    @JsonProperty
    private double progress;
    @JsonProperty
    private List<String> feed;
    @JsonProperty
    private List<String> sources;
    @JsonProperty
    private double sample;
    @JsonProperty
    private List<Chunk> chunks;

    public static HistoricsQuery fromString(String historicsQueryId) {
        if (historicsQueryId == null || historicsQueryId.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a stream from an empty or null string");
        }
        HistoricsQuery stream = new HistoricsQuery();
        stream.id = historicsQueryId;
        return stream;
    }

    public String getId() {
        return this.id;
    }

    public String getDefinitationId() {
        return this.definitationId;
    }

    public String getName() {
        return this.name;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public String getStatus() {
        return this.status;
    }

    public double getProgress() {
        return this.progress;
    }

    public List<String> getFeed() {
        return this.feed == null ? new ArrayList() : this.feed;
    }

    public List<String> getSources() {
        return this.sources == null ? new ArrayList() : this.sources;
    }

    public double getSample() {
        return this.sample;
    }

    public List<Chunk> getChunks() {
        return this.chunks == null ? new ArrayList() : this.chunks;
    }

    public static class Chunk {
        @JsonProperty
        private String status;
        @JsonProperty
        private double progress;
        @JsonProperty(value="start_time")
        private long startTime;
        @JsonProperty(value="end_time")
        private long endTime;
        @JsonProperty(value="estimated_completion")
        private long estimatedCompletion;

        public String getStatus() {
            return this.status;
        }

        public double getProgress() {
            return this.progress;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setProgress(double progress) {
            this.progress = progress;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public void setEstimatedCompletion(long estimatedCompletion) {
            this.estimatedCompletion = estimatedCompletion;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public long getEstimatedCompletion() {
            return this.estimatedCompletion;
        }

        public long getStartTime() {
            return this.startTime;
        }
    }
}

