/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.preview;

import com.datasift.client.DataSiftApiClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.FutureData;
import com.datasift.client.core.Stream;
import com.datasift.client.preview.HistoricsPreview;
import com.datasift.client.preview.HistoricsPreviewData;
import io.higgs.http.client.POST;
import io.higgs.http.client.Request;
import io.higgs.http.client.future.PageReader;
import io.higgs.http.client.future.Reader;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public class DataSiftPreview
extends DataSiftApiClient {
    public final String CREATE = "preview/create";
    public final String GET = "preview/get";

    public DataSiftPreview(DataSiftConfig config) {
        super(config);
    }

    public FutureData<HistoricsPreview> create(DateTime now, Stream stream, String[] params) {
        return this.create(now, null, stream, params);
    }

    public FutureData<HistoricsPreview> create(DateTime start, DateTime end, Stream hash, String[] params) {
        if (start == null || hash == null || params == null) {
            throw new IllegalArgumentException("A valid params, hash, start time are required");
        }
        return this.create(TimeUnit.MILLISECONDS.toSeconds(start.getMillis()), end == null ? 0L : TimeUnit.MILLISECONDS.toSeconds(end.getMillis()), hash, params);
    }

    public FutureData<HistoricsPreview> create(long start, long end, String hash, String[] parameters) {
        if (hash == null || parameters == null) {
            throw new IllegalArgumentException("Valid params and hash are required");
        }
        return this.create(start, end, Stream.fromString(hash), parameters);
    }

    public FutureData<HistoricsPreview> create(long start, long end, Stream stream, String[] parameters) {
        if (stream == null) {
            throw new IllegalArgumentException("A valid hash is required");
        }
        if (parameters == null || parameters.length == 0) {
            throw new IllegalArgumentException("A at least 1 historics preview parameter is required");
        }
        if (parameters.length > 20) {
            throw new IllegalArgumentException("No more than 20 historics preview parameters are allowed");
        }
        FutureData<HistoricsPreview> future = new FutureData<HistoricsPreview>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("preview/create"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new HistoricsPreview(), this.config))).form("start", (Object)start).form("hash", (Object)stream.hash());
        StringBuilder b = new StringBuilder();
        for (String p : parameters) {
            b.append(p).append(',');
        }
        request.form("parameters", (Object)b.toString().substring(0, b.length() - 1));
        if (end > 0L) {
            request.form("end", (Object)end);
        }
        this.applyConfig((Request)request).execute();
        return future;
    }

    public FutureData<HistoricsPreviewData> get(String id) {
        return this.get(HistoricsPreview.fromString(id));
    }

    public FutureData<HistoricsPreviewData> get(HistoricsPreview preview) {
        if (preview == null || preview.id() == null) {
            throw new IllegalArgumentException("A valid preview isntance is required");
        }
        FutureData<HistoricsPreviewData> future = new FutureData<HistoricsPreviewData>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("preview/get"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new HistoricsPreviewData(), this.config))).form("id", (Object)preview.id());
        this.applyConfig((Request)request).execute();
        return future;
    }
}

