/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.push;

import com.datasift.client.DataSiftApiClient;
import com.datasift.client.DataSiftClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.DataSiftResult;
import com.datasift.client.FutureData;
import com.datasift.client.FutureResponse;
import com.datasift.client.Response;
import com.datasift.client.core.Stream;
import com.datasift.client.historics.HistoricsQuery;
import com.datasift.client.historics.PreparedHistoricsQuery;
import com.datasift.client.push.PulledInteractions;
import com.datasift.client.push.PushCollection;
import com.datasift.client.push.PushLogMessages;
import com.datasift.client.push.PushSubscription;
import com.datasift.client.push.PushValidation;
import com.datasift.client.push.Status;
import com.datasift.client.push.connectors.PushConnector;
import com.datasift.client.stream.Interaction;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import io.higgs.core.func.Function2;
import io.higgs.http.client.POST;
import io.higgs.http.client.Request;
import io.higgs.http.client.future.PageReader;
import io.higgs.http.client.future.Reader;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class DataSiftPush
extends DataSiftApiClient {
    public final String VALIDATE = "push/validate";
    public final String CREATE = "push/create";
    public final String PAUSE = "push/pause";
    public final String RESUME = "push/resume";
    public final String UPDATE = "push/update";
    public final String STOP = "push/stop";
    public final String DELETE = "push/delete";
    public final String LOG = "push/log";
    public final String GET = "push/get";
    public final String PULL = "pull";

    public DataSiftPush(DataSiftConfig config) {
        super(config);
    }

    public FutureData<PushSubscription> pause(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("A push subscription ID is required");
        }
        FutureData<PushSubscription> future = new FutureData<PushSubscription>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/pause"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new PushSubscription(), this.config))).form("id", (Object)id);
        this.applyConfig((Request)request).execute();
        return future;
    }

    public FutureData<PushSubscription> resume(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("A push subscription ID is required");
        }
        FutureData<PushSubscription> future = new FutureData<PushSubscription>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/resume"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new PushSubscription(), this.config))).form("id", (Object)id);
        this.applyConfig((Request)request).execute();
        return future;
    }

    public FutureData<PushSubscription> stop(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("A push subscription ID is required");
        }
        FutureData<PushSubscription> future = new FutureData<PushSubscription>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/stop"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new PushSubscription(), this.config))).form("id", (Object)id);
        this.applyConfig((Request)request).execute();
        return future;
    }

    public FutureData<DataSiftResult> delete(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("A push subscription ID is required");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/delete"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new DataSiftResult(), this.config))).form("id", (Object)id);
        this.applyConfig((Request)request).execute();
        return future;
    }

    public FutureData<PushSubscription> update(String id, PushConnector connector) {
        return this.update(id, connector, null);
    }

    public FutureData<PushSubscription> update(String id, PushConnector connector, String name) {
        if (id == null || id.isEmpty() || connector == null) {
            throw new IllegalArgumentException("A push subscription ID and output parameters is required");
        }
        FutureData<PushSubscription> future = new FutureData<PushSubscription>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/update"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new PushSubscription(), this.config))).form("id", (Object)id);
        for (Map.Entry<String, String> e : connector.parameters().verifyAndGet().entrySet()) {
            request.form(e.getKey(), (Object)e.getValue());
        }
        if (name != null && !name.isEmpty()) {
            request.form("name", (Object)name);
        }
        this.applyConfig((Request)request).execute();
        return future;
    }

    public FutureData<PulledInteractions> pull(String id, int size, String cursor) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("A push subscription ID is required");
        }
        final FutureData<PulledInteractions> future = new FutureData<PulledInteractions>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pull"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader((Function2)new Function2<String, io.higgs.http.client.Response>(){

            public void apply(String s, io.higgs.http.client.Response response) {
                if (!response.hasFailed()) {
                    CollectionType type = DataSiftClient.MAPPER.getTypeFactory().constructCollectionType(List.class, Interaction.class);
                    try {
                        List interactions = (List)DataSiftClient.MAPPER.readValue(s, (JavaType)type);
                        PulledInteractions pi = new PulledInteractions();
                        pi.data(interactions);
                        future.received(pi);
                    }
                    catch (IOException e) {
                        this.fail(s, response, e);
                    }
                } else {
                    this.fail(s, response, null);
                }
            }

            private void fail(String s, io.higgs.http.client.Response response, Throwable e) {
                PulledInteractions pi = new PulledInteractions();
                pi.failed(e != null ? e : response.failureCause());
                pi.setResponse(new Response(s, response));
                future.received(pi);
            }
        })).form("id", (Object)id);
        if (cursor != null && !cursor.isEmpty()) {
            request.form("cursor", (Object)cursor);
        }
        if (size > 0) {
            request.form("size", (Object)size);
        }
        this.applyConfig((Request)request).execute();
        return future;
    }

    public FutureData<PushLogMessages> log(String id, int page) {
        return this.log(id, page, 0, null, null);
    }

    public FutureData<PushLogMessages> log(String id, int page, int perPage, String orderBy, String orderDirection) {
        FutureData<PushLogMessages> future = new FutureData<PushLogMessages>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/log"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new PushLogMessages(), this.config)));
        if (id != null && !id.isEmpty()) {
            request.form("id", (Object)id);
        }
        if (page > 0) {
            request.form("page", (Object)page);
        }
        if (perPage > 0) {
            request.form("per_page", (Object)perPage);
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            request.form("order_by", (Object)orderBy);
        }
        if (orderDirection != null && !orderDirection.isEmpty()) {
            request.form("order_dir", (Object)orderDirection);
        }
        this.applyConfig((Request)request).execute();
        return future;
    }

    public FutureData<PushSubscription> get(String id) {
        if (id == null) {
            throw new IllegalArgumentException("A subscription ID is required");
        }
        FutureData<PushSubscription> future = new FutureData<PushSubscription>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/get"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new PushSubscription(), this.config)));
        request.form("id", (Object)id);
        this.applyConfig((Request)request).execute();
        return future;
    }

    public FutureData<PushCollection> get(Stream hash, int page, int perPage, String orderBy, String orderDirection, boolean includeFinished) {
        FutureData<PushCollection> future = new FutureData<PushCollection>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/get"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new PushCollection(), this.config)));
        request.form("hash", (Object)hash.hash()).form("include_finished", (Object)(includeFinished ? 1 : 0));
        if (page > 0) {
            request.form("page", (Object)page);
        }
        if (perPage > 0) {
            request.form("per_page", (Object)perPage);
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            request.form("order_by", (Object)orderBy);
        }
        if (orderDirection != null && !orderDirection.isEmpty()) {
            request.form("order_dir", (Object)orderDirection);
        }
        this.applyConfig((Request)request).execute();
        return future;
    }

    public FutureData<PushCollection> get(HistoricsQuery historics, int page, int perPage, String orderBy, String orderDirection, boolean includeFinished) {
        FutureData<PushCollection> future = new FutureData<PushCollection>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/get"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new PushCollection(), this.config)));
        request.form("historics_id", (Object)historics.getId()).form("include_finished", (Object)(includeFinished ? 1 : 0));
        if (page > 0) {
            request.form("page", (Object)page);
        }
        if (perPage > 0) {
            request.form("per_page", (Object)perPage);
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            request.form("order_by", (Object)orderBy);
        }
        if (orderDirection != null && !orderDirection.isEmpty()) {
            request.form("order_dir", (Object)orderDirection);
        }
        this.applyConfig((Request)request).execute();
        return future;
    }

    public <T extends PushConnector> FutureData<PushValidation> validate(T connector) {
        FutureData<PushValidation> future = new FutureData<PushValidation>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/validate"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new PushValidation(), this.config))).form("output_type", (Object)connector.type().value());
        for (Map.Entry<String, String> e : connector.parameters().verifyAndGet().entrySet()) {
            request.form(e.getKey(), (Object)e.getValue());
        }
        this.applyConfig((Request)request).execute();
        return future;
    }

    public <T extends PushConnector> FutureData<PushSubscription> create(T connector, FutureData<PreparedHistoricsQuery> historics, FutureData<Stream> stream, String name) {
        return this.create(connector, historics, stream, name, null, 0L, 0L);
    }

    public <T extends PushConnector> FutureData<PushSubscription> create(T connector, PreparedHistoricsQuery historics, String name, Status initialStatus, long start, long end) {
        return this.create(connector, FutureData.wrap(historics), null, name, initialStatus, start, end);
    }

    public <T extends PushConnector> FutureData<PushSubscription> create(T con, FutureData<PreparedHistoricsQuery> query, String name) {
        return this.create(con, query, null, name);
    }

    public <T extends PushConnector> FutureData<PushSubscription> create(T con, Stream stream, String name) {
        return this.create(con, stream, name, null, 0L, 0L);
    }

    public <T extends PushConnector> FutureData<PushSubscription> create(T connector, Stream stream, String name, Status initialStatus, long start, long end) {
        return this.create(connector, null, FutureData.wrap(stream), name, initialStatus, start, end);
    }

    public <T extends PushConnector> FutureData<PushSubscription> create(final T connector, FutureData<PreparedHistoricsQuery> historics, FutureData<Stream> stream, final String name, final Status initialStatus, final long start, final long end) {
        if (name == null) {
            throw new IllegalArgumentException("Name is required in order to create a push subscription");
        }
        if (historics != null && stream != null) {
            throw new IllegalArgumentException("A push subscription cannot be created with both a historic and live stream. One must be null");
        }
        if (end > 0L && end <= start) {
            throw new IllegalArgumentException("If end is specified it must be greater than the start");
        }
        final FutureData<PushSubscription> future = new FutureData<PushSubscription>();
        final PushSubscription subscription = new PushSubscription();
        if (historics != null) {
            this.unwrapFuture(historics, future, subscription, new FutureResponse<PreparedHistoricsQuery>(){

                @Override
                public void apply(PreparedHistoricsQuery data) {
                    DataSiftPush.this.performCreateQuery(connector, name, initialStatus, start, end, future, subscription, data, null);
                }
            });
        }
        if (stream != null) {
            this.unwrapFuture(stream, future, subscription, new FutureResponse<Stream>(){

                @Override
                public void apply(Stream data) {
                    DataSiftPush.this.performCreateQuery(connector, name, initialStatus, start, end, future, subscription, null, data);
                }
            });
        }
        return future;
    }

    private <T extends PushConnector> void performCreateQuery(T connector, String name, Status initialStatus, long start, long end, FutureData<PushSubscription> future, PushSubscription subscription, PreparedHistoricsQuery historics, Stream stream) {
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/create"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, subscription, this.config))).form("output_type", (Object)connector.type().value()).form("name", (Object)name);
        for (Map.Entry<String, String> e : connector.parameters().verifyAndGet().entrySet()) {
            request.form(e.getKey(), (Object)e.getValue());
        }
        if (historics != null) {
            request.form("historics_id", (Object)historics.getId());
        } else {
            request.form("hash", (Object)stream.hash());
        }
        if (initialStatus != null) {
            request.form("initial_status", (Object)initialStatus.val());
        }
        if (start > 0L) {
            request.form("start", (Object)start);
        }
        if (end > 0L) {
            request.form("end", (Object)end);
        }
        this.applyConfig((Request)request).execute();
    }
}

