/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.push.connectors;

import com.datasift.client.push.OutputType;
import com.datasift.client.push.connectors.BaseConnector;

public class SFTP
extends BaseConnector<SFTP> {
    public SFTP() {
        super(OutputType.SFTP_OUTPUT);
        this.setup(this, "host", "port", "directory", "delivery_frequency", "max_size", "auth.username", "auth.password");
    }

    public SFTP url(String host, int port) {
        return this.host(host).port(port);
    }

    public SFTP host(String host) {
        return (SFTP)this.setParam("host", host);
    }

    public SFTP port(int host) {
        return (SFTP)this.setParam("port", String.valueOf(host));
    }

    public SFTP directory(String directory) {
        return (SFTP)this.setParam("directory", directory);
    }

    public SFTP deliveryFrequency(int freq) {
        return (SFTP)this.setParam("delivery_frequency", String.valueOf(freq));
    }

    public SFTP maxSize(int max) {
        return (SFTP)this.setParam("max_size", String.valueOf(max));
    }

    public SFTP filePrefix(String prefix) {
        return (SFTP)this.setParam("file_prefix", prefix);
    }

    public SFTP auth(String username, String password) {
        return this.username(username).password(password);
    }

    public SFTP username(String username) {
        return (SFTP)this.setParam("auth.username", username);
    }

    public SFTP password(String password) {
        return (SFTP)this.setParam("auth.password", password);
    }

    public SFTP markInProgress(boolean trueOrFalse) {
        return (SFTP)this.setParam("mark_in_progress", String.valueOf(trueOrFalse));
    }

    public SFTP format(SFTPFormat format) {
        String strFormat;
        switch (format) {
            case JSON_ARRAY: {
                strFormat = "json_array";
                break;
            }
            case JSON_NEW_LINE: {
                strFormat = "json_new_line";
                break;
            }
            default: {
                strFormat = "json_meta";
            }
        }
        return (SFTP)this.setParam("format", strFormat);
    }

    public static enum SFTPFormat {
        JSON_META,
        JSON_ARRAY,
        JSON_NEW_LINE;


        public static SFTPFormat fromStr(String str) {
            try {
                return SFTPFormat.valueOf(str.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                return SFTPFormat.valueOf(str);
            }
        }
    }
}

