/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.stream;

import com.datasift.client.core.Stream;
import com.datasift.client.stream.DataSiftMessage;
import com.datasift.client.stream.Interaction;

public abstract class StreamSubscription {
    private Stream stream;

    public StreamSubscription(Stream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream can't be null");
        }
        if (stream.hash() == null || stream.hash().isEmpty()) {
            throw new IllegalArgumentException("Invalid stream subscription request, no hash available");
        }
        this.stream = stream;
    }

    public Stream stream() {
        return this.stream;
    }

    public abstract void onDataSiftLogMessage(DataSiftMessage var1);

    public abstract void onMessage(Interaction var1);

    public void onConnect() {
    }

    public void onClose() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamSubscription that = (StreamSubscription)o;
        return !(this.stream != null ? !this.stream.equals(that.stream) : that.stream != null);
    }

    public int hashCode() {
        return this.stream != null ? this.stream.hashCode() : 0;
    }
}

