/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client;

import com.datasift.client.DataSiftClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.DataSiftResult;
import com.datasift.client.FutureData;
import com.datasift.client.FutureResponse;
import com.datasift.client.ParamBuilder;
import com.datasift.client.Response;
import com.datasift.client.exceptions.AuthException;
import com.datasift.client.exceptions.DataSiftException;
import com.datasift.client.exceptions.JsonParsingException;
import io.higgs.core.func.Function2;
import io.higgs.http.client.Request;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;

public class DataSiftApiClient {
    protected DataSiftConfig config;

    public DataSiftApiClient(DataSiftConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        this.config = config;
    }

    public ParamBuilder newParams() {
        return new ParamBuilder();
    }

    protected <T extends DataSiftResult> Function2<String, io.higgs.http.client.Response> newRequestCallback(final FutureData<T> future, final T instance, DataSiftConfig config) {
        return new Function2<String, io.higgs.http.client.Response>(){

            public void apply(String s, io.higgs.http.client.Response response) {
                DataSiftResult result = instance;
                if (response.getStatus() != null && HttpResponseStatus.NO_CONTENT.equals((Object)response.getStatus())) {
                    result.successful();
                } else {
                    if (response.hasFailed()) {
                        result.failed(response.failureCause());
                        throw new DataSiftException("API request failed", response.failureCause(), response);
                    }
                    try {
                        result = (DataSiftResult)DataSiftClient.MAPPER.readValue(s, instance.getClass());
                    }
                    catch (IOException e) {
                        result.failed(e);
                        throw new JsonParsingException("Unable to decode JSON from DataSift response", e, response);
                    }
                }
                result.setResponse(new Response(s, response));
                if (response.getStatus().code() == 401) {
                    throw new AuthException("Please provide a valid username and API key", response);
                }
                if (!result.isSuccessful()) {
                    throw new DataSiftException(result.getError(), result.failureCause());
                }
                future.received(result);
            }
        };
    }

    protected <T extends DataSiftResult, A extends DataSiftResult> void unwrapFuture(FutureData<T> futureToUnwrap, final FutureData<A> futureReturnedToUser, final A expectedInstance, final FutureResponse<T> responseToExecuteOnSuccess) {
        futureToUnwrap.onData(new FutureResponse<T>(){

            @Override
            public void apply(T stream) {
                if (stream.isSuccessful()) {
                    responseToExecuteOnSuccess.apply(stream);
                } else {
                    expectedInstance.setResponse(stream.getResponse());
                    futureReturnedToUser.received(expectedInstance);
                }
            }
        });
    }

    protected <T extends DataSiftResult> void performRequest(final FutureData<T> response, Request request) {
        request.header("Authorization", this.config.authAsHeader());
        request.withSSLProtocols(this.config.sslProtocols());
        io.higgs.http.client.FutureResponse execution = request.execute();
        execution.addListener((GenericFutureListener)new GenericFutureListener<Future<? super io.higgs.http.client.Response>>(){

            public void operationComplete(Future<? super io.higgs.http.client.Response> future) throws Exception {
                if (!future.isSuccess()) {
                    response.interuptCause(future.cause());
                    response.doNotify();
                }
            }
        });
    }
}

