/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.stream;

import com.datasift.client.DataSiftClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.core.Stream;
import com.datasift.client.stream.DataSiftMessage;
import com.datasift.client.stream.DeletedInteraction;
import com.datasift.client.stream.ErrorListener;
import com.datasift.client.stream.Interaction;
import com.datasift.client.stream.MultiStreamInteraction;
import com.datasift.client.stream.StreamEventListener;
import com.datasift.client.stream.StreamSubscription;
import io.higgs.ws.client.WebSocketClient;
import io.higgs.ws.client.WebSocketEventListener;
import io.higgs.ws.client.WebSocketMessage;
import io.higgs.ws.client.WebSocketStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.cliffc.high_scale_lib.NonBlockingHashSet;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingData
implements WebSocketEventListener {
    protected URI endpoint;
    protected WebSocketStream liveStream;
    protected DataSiftConfig config;
    protected Map<Stream, StreamSubscription> subscriptions = new NonBlockingHashMap();
    protected ErrorListener errorListener;
    protected StreamEventListener streamEventListener;
    protected boolean connected;
    protected Set<StreamSubscription> unsentSubscriptions = new NonBlockingHashSet();
    protected short MAX_TIMEOUT = (short)320;
    protected short currentTimeout = 1;
    protected DateTime lastSeen;
    protected static Set<StreamingData> streams = new NonBlockingHashSet();
    public static boolean detectDeadConnection = true;
    public static int CONNECTION_TIMEOUT_LIMIT = 65;
    public static int CONNECTION_TIMEOUT = 65;
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public StreamingData(DataSiftConfig config) {
        try {
            this.endpoint = new URI(String.format((config.isSslEnabled() ? "wss" : "ws") + "://websocket.datasift.com:" + config.port() + "/multi?username=%s&api_key=%s", config.getUsername(), config.getApiKey()));
        }
        catch (URISyntaxException e) {
            this.log.error("Unable to create endpoint URL", (Throwable)e);
        }
        this.config = config;
        streams.add(this);
    }

    public synchronized void onConnect(ChannelHandlerContext ctx) {
        this.streamEventListener.streamOpened();
        this.connected = true;
        this.pushUnsentSubscriptions();
    }

    public synchronized void onClose(ChannelHandlerContext ctx, CloseWebSocketFrame frame) {
        this.closeAndReconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndReconnect() {
        this.streamEventListener.streamClosed();
        StreamingData streamingData = this;
        synchronized (streamingData) {
            this.connected = false;
        }
        if (this.config.isAutoReconnect() && TimeUnit.SECONDS.toMillis(this.currentTimeout) <= TimeUnit.SECONDS.toMillis(this.MAX_TIMEOUT)) {
            this.currentTimeout = (short)(this.currentTimeout * 2);
        }
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(this.currentTimeout));
        }
        catch (InterruptedException ignored) {
            this.log.info("Sleep interrupted, reconnecting");
        }
        this.liveStream = null;
        this.unsentSubscriptions.addAll(this.subscriptions.values());
        this.connect();
    }

    public void onPing(ChannelHandlerContext ctx, PingWebSocketFrame frame) {
        this.currentTimeout = 1;
        this.lastSeen = DateTime.now();
    }

    public void onMessage(ChannelHandlerContext ctx, WebSocketMessage msg) {
        this.currentTimeout = 1;
        this.lastSeen = DateTime.now();
        try {
            MultiStreamInteraction mi = (MultiStreamInteraction)DataSiftClient.MAPPER.readValue(msg.data(), MultiStreamInteraction.class);
            if (mi.isDataSiftMessage()) {
                this.fireMessage(new DataSiftMessage(mi));
            } else if (mi.getData().get("deleted") != null) {
                this.streamEventListener.onDelete(new DeletedInteraction(mi));
            } else {
                this.fireInteraction(mi.getHash(), new Interaction(mi.getData()));
            }
        }
        catch (IOException e) {
            this.fireError(e);
        }
    }

    public void onError(ChannelHandlerContext ctx, Throwable cause, FullHttpResponse response) {
        if (cause != null) {
            this.fireError(cause);
        }
    }

    protected synchronized void connect() {
        if (this.liveStream == null) {
            this.liveStream = WebSocketClient.connect((URI)this.endpoint, (boolean)false, (String[])this.config.sslProtocols());
            this.liveStream.subscribe((WebSocketEventListener)this);
        }
    }

    protected void fireInteraction(String hash, Interaction interaction) {
        for (Map.Entry<Stream, StreamSubscription> e : this.subscriptions.entrySet()) {
            if (!e.getKey().isSameAs(hash)) continue;
            e.getValue().onMessage(interaction);
        }
    }

    protected void fireMessage(DataSiftMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Message can't be null!");
        }
        for (Map.Entry<Stream, StreamSubscription> e : this.subscriptions.entrySet()) {
            if (message.hashHashes()) {
                for (Stream hash : message.hashes()) {
                    if (!e.getKey().isSameAs(hash)) continue;
                    e.getValue().onDataSiftLogMessage(message);
                }
                continue;
            }
            e.getValue().onDataSiftLogMessage(message);
        }
    }

    protected void fireError(Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException("Error can't be null!");
        }
        this.errorListener.exceptionCaught(e);
    }

    public StreamingData onError(ErrorListener listener) {
        this.errorListener = listener;
        return this;
    }

    public void onStreamEvent(StreamEventListener streamEventListener) {
        this.streamEventListener = streamEventListener;
    }

    public StreamingData subscribe(StreamSubscription subscription) {
        if (this.errorListener == null) {
            throw new IllegalStateException("You must call listen before subscribing to streams otherwise you'll miss any exceptions that may occur");
        }
        if (this.streamEventListener == null) {
            throw new IllegalStateException("You must call onStreamEvent before subscribing to streams otherwise you'll miss delete messages, which you are required to handle");
        }
        this.connect();
        this.unsentSubscriptions.add(subscription);
        if (this.connected) {
            this.pushUnsentSubscriptions();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushUnsentSubscriptions() {
        for (final StreamSubscription subscription : this.unsentSubscriptions) {
            if (!this.connected || this.liveStream.channel() == null || !this.liveStream.channel().isActive()) {
                StreamingData streamingData = this;
                synchronized (streamingData) {
                    this.connected = false;
                    break;
                }
            }
            this.subscriptions.put(subscription.stream(), subscription);
            this.liveStream.send("{\"action\":\"subscribe\",\"hash\":\"" + subscription.stream().hash() + "\"}").addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

                public void operationComplete(Future<Void> future) throws Exception {
                    if (future.isSuccess()) {
                        StreamingData.this.unsentSubscriptions.remove(subscription);
                    } else {
                        StreamingData.this.fireError(future.cause());
                        StreamingData.this.subscribe(subscription);
                    }
                }
            });
        }
        if (!this.connected) {
            this.connect();
        }
    }

    public StreamingData unsubscribe(Stream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream can't be null");
        }
        if (stream.hash() == null || stream.hash().isEmpty()) {
            throw new IllegalArgumentException("Invalid stream subscription request, no hash available");
        }
        this.connect();
        this.liveStream.send(" { \"action\" : \"unsubscribe\" , \"hash\": \"" + stream.hash() + "\"}");
        this.subscriptions.remove(stream);
        for (StreamSubscription subscription : this.unsentSubscriptions) {
            if (!stream.isSameAs(subscription.stream())) continue;
            this.unsentSubscriptions.remove(subscription);
        }
        return this;
    }

    static {
        WebSocketClient.maxFramePayloadLength = 0x1400000;
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (detectDeadConnection) {
                    long now = DateTime.now().getMillis();
                    for (StreamingData data : streams) {
                        if (data.lastSeen == null || now - data.lastSeen.getMillis() < TimeUnit.SECONDS.toMillis(CONNECTION_TIMEOUT_LIMIT)) continue;
                        data.closeAndReconnect();
                    }
                    try {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(CONNECTION_TIMEOUT));
                    }
                    catch (InterruptedException e) {
                        LoggerFactory.getLogger(this.getClass()).info("Interrupted while waiting to check conn");
                    }
                }
            }
        }).start();
    }
}

