/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.dynamiclist.replace;

import com.datasift.client.BaseDataSiftResult;
import com.datasift.client.DataSiftApiClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.DataSiftResult;
import com.datasift.client.FutureData;
import com.datasift.client.dynamiclist.DynamicList;
import com.datasift.client.dynamiclist.replace.ReplaceList;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.higgs.http.client.POST;
import io.higgs.http.client.Request;
import io.higgs.http.client.readers.PageReader;
import io.higgs.http.client.readers.Reader;
import java.net.URI;
import java.util.List;

public class DataSiftDynamicListReplace
extends DataSiftApiClient {
    public static final String ADD = "list/replace/add";
    public static final String START = "list/replace/start";
    public static final String COMMIT = "list/replace/commit";
    public static final String ABORT = "list/replace/abort";

    public DataSiftDynamicListReplace(DataSiftConfig config) {
        super(config);
    }

    public FutureData<ReplaceList> start(DynamicList list) {
        if (list == null || list.getId() == null) {
            throw new IllegalArgumentException("A valid list is required");
        }
        FutureData<ReplaceList> future = new FutureData<ReplaceList>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(START));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new ReplaceList(), this.config))).form("list_id", (Object)list.getId());
        this.performRequest(future, (Request)request);
        return future;
    }

    public <T> FutureData<DataSiftResult> add(ReplaceList list, List<T> items) {
        if (list == null || list.getId() == null || items == null) {
            throw new IllegalArgumentException("Id and items are both required");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        ObjectMapper mapper = new ObjectMapper();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(ADD));
        try {
            POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).form("id", (Object)list.getId()).form("items", (Object)mapper.writeValueAsString(items));
            this.performRequest(future, (Request)request);
        }
        catch (JsonProcessingException e) {
            this.failNotify(future, e);
        }
        return future;
    }

    public FutureData<DataSiftResult> commit(ReplaceList list) {
        if (list == null || list.getId() == null) {
            throw new IllegalArgumentException("Id is required");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(COMMIT));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).form("id", (Object)list.getId());
        this.performRequest(future, (Request)request);
        return future;
    }

    public FutureData<DataSiftResult> abort(ReplaceList list) {
        if (list == null || list.getId() == null) {
            throw new IllegalArgumentException("Id is required");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(ABORT));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).form("id", (Object)list.getId());
        this.performRequest(future, (Request)request);
        return future;
    }
}

