/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.managedsource;

import com.datasift.client.BaseDataSiftResult;
import com.datasift.client.DataSiftApiClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.DataSiftResult;
import com.datasift.client.FutureData;
import com.datasift.client.FutureResponse;
import com.datasift.client.ParamBuilder;
import com.datasift.client.managedsource.ManagedDataSourceType;
import com.datasift.client.managedsource.ManagedSource;
import com.datasift.client.managedsource.ManagedSourceList;
import com.datasift.client.managedsource.ManagedSourceLog;
import com.datasift.client.managedsource.sources.DataSource;
import io.higgs.http.client.POST;
import io.higgs.http.client.Request;
import io.higgs.http.client.readers.PageReader;
import io.higgs.http.client.readers.Reader;
import java.net.URI;

public class DataSiftManagedSource
extends DataSiftApiClient {
    public static final String CREATE = "source/create";
    public static final String UPDATE = "source/update";
    public static final String START = "source/start";
    public static final String STOP = "source/stop";
    public static final String DELETE = "source/delete";
    public static final String GET = "source/get";
    public static final String LOG = "source/log";

    public DataSiftManagedSource(DataSiftConfig config) {
        super(config);
    }

    public <T extends DataSource> FutureData<ManagedSource> create(String name, T source) {
        return this.updateOrCreate(name, source, null);
    }

    public <T extends DataSource> FutureData<ManagedSource> update(String name, T source, ManagedSource id) {
        if (id == null) {
            throw new IllegalArgumentException("An existing managed source is required");
        }
        return this.updateOrCreate(name, source, id.getId());
    }

    protected <T extends DataSource> FutureData<ManagedSource> updateOrCreate(String name, T source, String id) {
        if (name == null || source == null) {
            throw new IllegalArgumentException("Name and a data source are both required");
        }
        FutureData<ManagedSource> future = new FutureData<ManagedSource>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(id == null ? CREATE : UPDATE));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new ManagedSource(), this.config))).form("source_type", (Object)source.type().value()).form("name", (Object)name);
        if (source.hasParams()) {
            request.form("parameters", (Object)source.getParametersAsJSON());
        }
        if (source.hasResources()) {
            request.form("resources", (Object)source.getResourcesAsJSON());
        }
        if (source.hasAuth()) {
            request.form("auth", (Object)source.getAuthAsJSON());
        }
        this.performRequest(future, (Request)request);
        return future;
    }

    public FutureData<DataSiftResult> start(String id) {
        return this.start(ManagedSource.fromString(id));
    }

    public FutureData<DataSiftResult> start(ManagedSource source) {
        return this.start(FutureData.wrap(source));
    }

    public FutureData<DataSiftResult> start(FutureData<ManagedSource> source) {
        if (source == null) {
            throw new IllegalArgumentException("A data source is required");
        }
        final FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        BaseDataSiftResult res = new BaseDataSiftResult();
        this.unwrapFuture(source, future, res, new FutureResponse<ManagedSource>(){

            @Override
            public void apply(ManagedSource data) {
                URI uri = DataSiftManagedSource.this.newParams().forURL(DataSiftManagedSource.this.config.newAPIEndpointURI(DataSiftManagedSource.START));
                POST request = DataSiftManagedSource.this.config.http().POST(uri, (Reader)new PageReader(DataSiftManagedSource.this.newRequestCallback(future, data, DataSiftManagedSource.this.config))).form("id", (Object)data.getId());
                DataSiftManagedSource.this.performRequest(future, (Request)request);
            }
        });
        return future;
    }

    public FutureData<ManagedSource> stop(String id) {
        if (id == null) {
            throw new IllegalArgumentException("A data source is required");
        }
        FutureData<ManagedSource> future = new FutureData<ManagedSource>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(STOP));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new ManagedSource(), this.config))).form("id", (Object)id);
        this.performRequest(future, (Request)request);
        return future;
    }

    public FutureData<DataSiftResult> delete(String id) {
        if (id == null) {
            throw new IllegalArgumentException("A data source is required");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(DELETE));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).form("id", (Object)id);
        this.performRequest(future, (Request)request);
        return future;
    }

    public FutureData<ManagedSourceList> get() {
        return this.get(null, 0, 0);
    }

    public FutureData<ManagedSourceList> get(int page) {
        return this.get(null, page, 0);
    }

    public FutureData<ManagedSourceList> get(int page, int perPage) {
        return this.get(null, page, perPage);
    }

    public FutureData<ManagedSourceList> get(ManagedDataSourceType type, int page, int perPage) {
        FutureData<ManagedSourceList> future = new FutureData<ManagedSourceList>();
        ParamBuilder b = this.newParams();
        if (type != null) {
            b.put("source_type", type.value());
        }
        if (page > 0) {
            b.put("page", page);
        }
        if (perPage > 0) {
            b.put("per_page", perPage);
        }
        URI uri = b.forURL(this.config.newAPIEndpointURI(GET));
        Request request = this.config.http().GET(uri, (Reader)new PageReader(this.newRequestCallback(future, new ManagedSourceList(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<ManagedSource> get(String id) {
        FutureData<ManagedSource> future = new FutureData<ManagedSource>();
        URI uri = this.newParams().put("id", id).forURL(this.config.newAPIEndpointURI(GET));
        Request request = this.config.http().GET(uri, (Reader)new PageReader(this.newRequestCallback(future, new ManagedSource(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<ManagedSourceLog> log(String id) {
        return this.log(id, 0, 0);
    }

    public FutureData<ManagedSourceLog> log(String id, int page) {
        return this.log(id, page, 0);
    }

    public FutureData<ManagedSourceLog> log(String id, int page, int perPage) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("A valid source ID is required");
        }
        FutureData<ManagedSourceLog> future = new FutureData<ManagedSourceLog>();
        ParamBuilder b = this.newParams();
        if (page > 0) {
            b.put("page", page);
        }
        if (perPage > 0) {
            b.put("per_page", perPage);
        }
        URI uri = b.forURL(this.config.newAPIEndpointURI(LOG));
        Request request = this.config.http().GET(uri, (Reader)new PageReader(this.newRequestCallback(future, new ManagedSourceLog(), this.config)));
        this.performRequest(future, request);
        return future;
    }
}

