/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.managedsource.sources;

import com.datasift.client.DataSiftConfig;
import com.datasift.client.managedsource.ManagedDataSourceType;
import com.datasift.client.managedsource.sources.BaseSource;

public class FacebookPage
extends BaseSource<FacebookPage> {
    public FacebookPage(DataSiftConfig config) {
        super(config, ManagedDataSourceType.FACEBOOK_PAGE);
    }

    public FacebookPage setParams(boolean enableLikes, boolean enableComments, boolean enablePostsByOthers) {
        return this.enableLikes(enableLikes).enableComments(enableComments).enablePostsByOthers(enablePostsByOthers);
    }

    public FacebookPage enableLikes(boolean enabled) {
        return (FacebookPage)this.setParametersField("likes", enabled);
    }

    public FacebookPage enablePostsByOthers(boolean enabled) {
        return (FacebookPage)this.setParametersField("posts_by_others", enabled);
    }

    public FacebookPage enableComments(boolean enabled) {
        return (FacebookPage)this.setParametersField("comments", enabled);
    }

    public FacebookPage addPage(String id, String url, String title) {
        BaseSource.ResourceParams parameterSet = this.newResourceParams();
        parameterSet.set("id", id);
        parameterSet.set("url", url);
        parameterSet.set("title", title);
        return this;
    }

    public FacebookPage addOAutToken(String oAuthAccessToken, String name, long expires) {
        if (oAuthAccessToken == null || oAuthAccessToken.isEmpty()) {
            throw new IllegalArgumentException("A valid OAutho token is required");
        }
        BaseSource.AuthParams parameterSet = this.newAuthParams(name, expires);
        parameterSet.set("value", oAuthAccessToken);
        return this;
    }
}

