/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.managedsource.sources;

import com.datasift.client.DataSiftClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.managedsource.ManagedDataSourceType;
import com.datasift.client.managedsource.sources.DataSource;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Map;
import java.util.Set;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.cliffc.high_scale_lib.NonBlockingHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSource<T extends DataSource<T>>
implements DataSource<T> {
    protected final ManagedDataSourceType<T> type;
    protected DataSiftConfig config;
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected Map<String, Object> parameters = new NonBlockingHashMap();
    protected Set<ResourceParams> resources = new NonBlockingHashSet();
    protected Set<AuthParams> auth = new NonBlockingHashSet();

    public BaseSource(DataSiftConfig config, ManagedDataSourceType<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("A type is required, cannot be null");
        }
        this.config = config;
        this.type = type;
    }

    @Override
    public ManagedDataSourceType<T> type() {
        return this.type;
    }

    @Override
    public boolean hasAuth() {
        return this.auth.size() > 0;
    }

    @Override
    public boolean hasResources() {
        return this.resources.size() > 0;
    }

    @Override
    public boolean hasParams() {
        return this.parameters.size() > 0;
    }

    protected T setParametersField(String name, Object value) {
        if (name == null || name.isEmpty() || value == null) {
            throw new IllegalArgumentException("Both name and value are required");
        }
        this.parameters.put(name, value);
        return (T)this;
    }

    public AuthParams newAuthParams(String name, long expires) {
        AuthParams set = new AuthParams();
        set.name(name);
        set.expires(expires);
        this.auth.add(set);
        return set;
    }

    public ResourceParams newResourceParams() {
        ResourceParams set = new ResourceParams();
        this.resources.add(set);
        return set;
    }

    @Override
    public String getParametersAsJSON() {
        try {
            return DataSiftClient.MAPPER.writeValueAsString(this.parameters);
        }
        catch (JsonProcessingException e) {
            this.log.warn("Failed to encode parameters", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getResourcesAsJSON() {
        try {
            return DataSiftClient.MAPPER.writeValueAsString(this.resources);
        }
        catch (JsonProcessingException e) {
            this.log.warn("Failed to encode parameters", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getAuthAsJSON() {
        try {
            return DataSiftClient.MAPPER.writeValueAsString(this.auth);
        }
        catch (JsonProcessingException e) {
            this.log.warn("Failed to encode parameters", (Throwable)e);
            return null;
        }
    }

    public static class AuthParams {
        @JsonProperty
        private Map<String, Object> parameters = new NonBlockingHashMap();
        @JsonProperty(value="expires_at")
        private long expires;
        @JsonProperty
        private String name;

        protected AuthParams() {
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public void set(String name, String value) {
            this.parameters.put(name, value);
        }

        public void expires(long expires) {
            this.expires = expires;
        }

        public void name(String name) {
            this.name = name;
        }
    }

    public static class ResourceParams {
        @JsonProperty
        private Map<String, Object> parameters = new NonBlockingHashMap();
        @JsonProperty
        private String name;

        protected ResourceParams() {
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public void set(String name, Object value) {
            this.parameters.put(name, value);
        }

        public void name(String name) {
            this.name = name;
        }
    }
}

