/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.stream;

import com.datasift.client.DataSiftClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.core.Stream;
import com.datasift.client.stream.DataSiftMessage;
import com.datasift.client.stream.DeletedInteraction;
import com.datasift.client.stream.ErrorListener;
import com.datasift.client.stream.Interaction;
import com.datasift.client.stream.MultiStreamInteraction;
import com.datasift.client.stream.StreamEventListener;
import com.datasift.client.stream.StreamSubscription;
import io.higgs.ws.client.WebSocketClient;
import io.higgs.ws.client.WebSocketEventListener;
import io.higgs.ws.client.WebSocketMessage;
import io.higgs.ws.client.WebSocketStream;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.cliffc.high_scale_lib.NonBlockingHashSet;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataSiftConnection
implements WebSocketEventListener {
    protected final DataSiftConfig config;
    protected final URI endpoint;
    protected WebSocketStream connection;
    protected int maxAllowedSubscriptions;
    protected StreamEventListener streamEventListener;
    protected ErrorListener errorListener;
    protected short MAX_TIMEOUT = (short)320;
    protected short currentTimeout;
    protected DateTime lastSeen;
    protected Map<Stream, StreamSubscription> subscriptions = new NonBlockingHashMap();
    protected final Set<StreamSubscription> unsentSubscriptions = new NonBlockingHashSet();
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected boolean handshakeCompleted;

    protected DataSiftConnection(int maxAllowedSubscriptions, DataSiftConfig config, URI endpoint, ErrorListener errorListener, StreamEventListener streamEventListener) {
        this.maxAllowedSubscriptions = maxAllowedSubscriptions;
        this.config = config;
        this.endpoint = endpoint;
        this.errorListener = errorListener;
        this.streamEventListener = streamEventListener;
        this.connect();
    }

    protected DateTime lastSeen() {
        return this.lastSeen;
    }

    protected void setStreamEventListener(StreamEventListener streamEventListener) {
        this.streamEventListener = streamEventListener;
    }

    protected void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    protected synchronized boolean canTakeSubscription() {
        return this.unsentSubscriptions.size() + this.subscriptions.size() <= this.maxAllowedSubscriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subscribe(StreamSubscription subscription) {
        Set<StreamSubscription> set = this.unsentSubscriptions;
        synchronized (set) {
            this.unsentSubscriptions.add(subscription);
        }
        this.pushUnsentSubscriptions();
    }

    protected synchronized void pushUnsentSubscriptions() {
        for (final StreamSubscription subscription : this.unsentSubscriptions) {
            if (this.connection == null || !this.connection.channel().isActive()) {
                this.connect();
                return;
            }
            if (!this.handshakeCompleted) {
                return;
            }
            this.connection.connectFuture().syncUninterruptibly();
            this.connection.send("{\"action\":\"subscribe\",\"hash\":\"" + subscription.stream().hash() + "\"}").addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        DataSiftConnection.this.subscriptions.put(subscription.stream(), subscription);
                        DataSiftConnection.this.unsentSubscriptions.remove(subscription);
                    } else {
                        DataSiftConnection.this.fireError(future.cause());
                        DataSiftConnection.this.subscribe(subscription);
                    }
                }
            });
        }
    }

    protected void unsubscribe(Stream stream) {
        if (this.connection == null) {
            this.connect();
            return;
        }
        this.connection.send(" { \"action\" : \"unsubscribe\" , \"hash\": \"" + stream.hash() + "\"}");
        this.subscriptions.remove(stream);
        for (StreamSubscription subscription : this.unsentSubscriptions) {
            if (!stream.isSameAs(subscription.stream())) continue;
            this.unsentSubscriptions.remove(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnect(ChannelHandlerContext ctx) {
        DataSiftConnection dataSiftConnection = this;
        synchronized (dataSiftConnection) {
            this.handshakeCompleted = true;
        }
        this.streamEventListener.streamOpened();
        this.pushUnsentSubscriptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(ChannelHandlerContext ctx, CloseWebSocketFrame frame) {
        DataSiftConnection dataSiftConnection = this;
        synchronized (dataSiftConnection) {
            this.handshakeCompleted = false;
        }
        this.streamEventListener.streamClosed();
        this.unsentSubscriptions.addAll(this.subscriptions.values());
        this.subscriptions.clear();
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAndReconnect() {
        try {
            this.connection.channel().close();
        }
        finally {
            this.connect();
        }
    }

    protected void connect() {
        if (this.connection != null && this.connection.channel().isActive()) {
            return;
        }
        if (this.currentTimeout < 1) {
            this.currentTimeout = 1;
        } else {
            if (this.config.isAutoReconnect() && TimeUnit.SECONDS.toMillis(this.currentTimeout) <= TimeUnit.SECONDS.toMillis(this.MAX_TIMEOUT)) {
                this.currentTimeout = (short)(this.currentTimeout * 2);
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(this.currentTimeout));
            }
            catch (InterruptedException ignored) {
                this.log.info("Sleep interrupted, reconnecting");
            }
        }
        this.connection = WebSocketClient.connect((URI)this.endpoint, (boolean)false, (String[])this.config.sslProtocols());
        this.connection.subscribe((WebSocketEventListener)this);
        this.connection.connectFuture().syncUninterruptibly();
    }

    public void onPing(ChannelHandlerContext ctx, PingWebSocketFrame frame) {
        this.currentTimeout = 1;
        this.lastSeen = DateTime.now();
    }

    public void onMessage(ChannelHandlerContext ctx, WebSocketMessage msg) {
        this.currentTimeout = 1;
        this.lastSeen = DateTime.now();
        try {
            MultiStreamInteraction mi = (MultiStreamInteraction)DataSiftClient.MAPPER.readValue(msg.data(), MultiStreamInteraction.class);
            if (mi.isDataSiftMessage()) {
                this.fireMessage(new DataSiftMessage(mi));
            } else if (mi.getData().get("deleted") != null) {
                this.streamEventListener.onDelete(new DeletedInteraction(mi));
            } else {
                this.fireInteraction(mi.getHash(), new Interaction(mi.getData()));
            }
        }
        catch (IOException e) {
            this.fireError(e);
        }
    }

    public void onError(ChannelHandlerContext ctx, Throwable cause, FullHttpResponse response) {
        if (cause != null) {
            this.fireError(cause);
        }
    }

    protected void fireInteraction(String hash, Interaction interaction) {
        for (Map.Entry<Stream, StreamSubscription> e : this.subscriptions.entrySet()) {
            if (!e.getKey().isSameAs(hash)) continue;
            e.getValue().onMessage(interaction);
        }
    }

    protected void fireMessage(DataSiftMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Message can't be null!");
        }
        for (Map.Entry<Stream, StreamSubscription> e : this.subscriptions.entrySet()) {
            if (message.hashHashes()) {
                for (Stream hash : message.hashes()) {
                    if (!e.getKey().isSameAs(hash)) continue;
                    e.getValue().onDataSiftLogMessage(message);
                }
                continue;
            }
            e.getValue().onDataSiftLogMessage(message);
        }
    }

    protected void fireError(Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException("Error can't be null!");
        }
        this.errorListener.exceptionCaught(e);
    }

    protected boolean isFor(Stream stream) {
        return this.subscriptions.get(stream) != null;
    }
}

