/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client;

import com.datasift.client.BaseDataSiftResult;
import com.datasift.client.FutureResponse;
import com.datasift.client.exceptions.DataSiftException;
import com.datasift.client.util.WrappedResponse;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.cliffc.high_scale_lib.NonBlockingHashSet;

public class FutureData<T> {
    protected NonBlockingHashSet<FutureResponse<T>> listeners = new NonBlockingHashSet();
    protected T data;
    protected Throwable interruptCause;
    protected final BlockingQueue<Object> block = new LinkedBlockingDeque<Object>();

    public static <A extends BaseDataSiftResult> FutureData<A> wrap(A obj) {
        if (obj == null) {
            throw new IllegalArgumentException("You cannot wrap null as future data");
        }
        FutureData future = new FutureData();
        obj.setResponse(new WrappedResponse());
        future.data = obj;
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void received(T data) {
        BlockingQueue<Object> blockingQueue = this.block;
        synchronized (blockingQueue) {
            this.data = data;
            this.notifyListeners();
            this.doNotify();
        }
    }

    public FutureData<T> onData(FutureResponse<T> response) {
        this.listeners.add(response);
        if (this.data != null) {
            response.apply(this.data);
            this.doNotify();
        }
        return this;
    }

    protected void notifyListeners() {
        for (FutureResponse res : this.listeners) {
            res.apply(this.data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNotify() {
        BlockingQueue<Object> blockingQueue = this.block;
        synchronized (blockingQueue) {
            this.block.add(new Object());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T sync() {
        Object object = this.block;
        synchronized (object) {
            if (this.data != null) {
                return this.data;
            }
            this.block.clear();
        }
        object = this;
        synchronized (object) {
            block11: {
                try {
                    this.block.take();
                }
                catch (InterruptedException e) {
                    if (this.interruptCause != null) break block11;
                    this.interruptCause = e;
                }
            }
            if (this.interruptCause != null) {
                if (this.interruptCause instanceof DataSiftException) {
                    throw (DataSiftException)this.interruptCause;
                }
                throw new DataSiftException("Interrupted while waiting for response", this.interruptCause);
            }
            return this.data;
        }
    }

    public void interuptCause(Throwable cause) {
        this.interruptCause = cause;
    }
}

