/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.managedsource.sources;

import com.datasift.client.DataSiftConfig;
import com.datasift.client.managedsource.ManagedDataSourceType;
import com.datasift.client.managedsource.sources.BaseSource;
import java.util.ArrayList;

public class GooglePlus
extends BaseSource<GooglePlus> {
    public GooglePlus(DataSiftConfig config) {
        super(config, ManagedDataSourceType.GOOGLE_PLUS);
    }

    public GooglePlus setParams(boolean enableComments, boolean enablePlusOnes) {
        return this.enableComments(enableComments).enablePlusOnes(enablePlusOnes);
    }

    public GooglePlus enableComments(boolean enabled) {
        return (GooglePlus)this.setParametersField("comments", enabled);
    }

    public GooglePlus enablePlusOnes(boolean enabled) {
        return (GooglePlus)this.setParametersField("plus_ones", enabled);
    }

    public GooglePlus addResource(Type type, String userId) {
        BaseSource.ResourceParams parameterSet = this.newResourceParams();
        switch (type) {
            case PUBLIC_ACTIVITIES: {
                parameterSet.set("type", "public_activities");
                break;
            }
            case PEOPLE_UPDATES: {
                if (userId == null || userId.isEmpty()) {
                    throw new IllegalArgumentException("If type is people_updates then userId is required");
                }
                parameterSet.set("type", "people_updates");
                parameterSet.set("user_id", userId);
                parameterSet.set("event_types", new ArrayList<String>(){
                    {
                        this.add("activities");
                    }
                });
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type");
            }
        }
        return this;
    }

    public GooglePlus addOAutToken(String oAuthAccessToken, String oAuthRefreshToken, String name, long expires) {
        if (oAuthAccessToken == null || oAuthAccessToken.isEmpty() || oAuthRefreshToken == null || oAuthRefreshToken.isEmpty()) {
            throw new IllegalArgumentException("A valid OAuth and refresh token is required");
        }
        BaseSource.AuthParams parameterSet = this.newAuthParams(name, expires);
        parameterSet.set("value", oAuthAccessToken);
        parameterSet.set("refresh_token", oAuthRefreshToken);
        return this;
    }

    public static enum Type {
        PEOPLE_UPDATES,
        PUBLIC_ACTIVITIES;

    }
}

