/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.push.connectors;

import com.datasift.client.push.OutputType;
import com.datasift.client.push.connectors.BaseConnector;

public class FTP
extends BaseConnector<FTP> {
    public FTP() {
        super(OutputType.FTP_TYPE);
        this.setup(this, "host", "port", "directory", "delivery_frequency", "max_size", "auth.username", "auth.password");
    }

    public FTP format(FTPFormat format) {
        String strFormat;
        switch (format) {
            case JSON_ARRAY: {
                strFormat = "json_array";
                break;
            }
            case JSON_NEW_LINE: {
                strFormat = "json_new_line";
                break;
            }
            default: {
                strFormat = "json_meta";
            }
        }
        return (FTP)this.setParam("format", strFormat);
    }

    public FTP url(String host, int port) {
        return this.host(host).port(port);
    }

    public FTP host(String host) {
        return (FTP)this.setParam("host", host);
    }

    public FTP port(int host) {
        return (FTP)this.setParam("port", String.valueOf(host));
    }

    public FTP directory(String name) {
        return (FTP)this.setParam("directory", name);
    }

    public FTP deliveryFrequency(int freq) {
        return (FTP)this.setParam("delivery_frequency", String.valueOf(freq));
    }

    public FTP maxSize(int max) {
        return (FTP)this.setParam("max_size", String.valueOf(max));
    }

    public FTP filePrefix(String prefix) {
        return (FTP)this.setParam("file_prefix", prefix);
    }

    public FTP auth(String username, String password) {
        return this.username(username).password(password);
    }

    public FTP username(String username) {
        return (FTP)this.setParam("auth.username", username);
    }

    public FTP password(String password) {
        return (FTP)this.setParam("auth.password", password);
    }

    public FTP markInProgress(boolean trueOrFalse) {
        return (FTP)this.setParam("mark_in_progress", String.valueOf(trueOrFalse));
    }

    public FTP gzip() {
        return this.compression("gzip");
    }

    public FTP compression(String format) {
        return (FTP)this.setParam("compression", format);
    }

    public static enum FTPFormat {
        JSON_META,
        JSON_ARRAY,
        JSON_NEW_LINE;


        public static FTPFormat fromStr(String str) {
            try {
                return FTPFormat.valueOf(str.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                return FTPFormat.valueOf(str);
            }
        }
    }
}

