/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.push.connectors;

import com.datasift.client.push.OutputType;
import com.datasift.client.push.connectors.BaseConnector;
import com.datasift.client.push.connectors.Prepared;
import io.netty.handler.codec.http.HttpMethod;

public class Http
extends BaseConnector<Http> {
    public Http() {
        super(OutputType.HTTP_TYPE);
        this.setup(this, "method", "url", "delivery_frequency", "max_size", "auth.type", "verify_ssl", "use_gzip");
    }

    public Http format(HttpFormat format) {
        String strFormat;
        switch (format) {
            case JSON_ARRAY: {
                strFormat = "json_array";
                break;
            }
            case JSON_NEW_LINE: {
                strFormat = "json_new_line";
                break;
            }
            default: {
                strFormat = "json_meta";
            }
        }
        return (Http)this.setParam("format", strFormat);
    }

    public Http method(HttpMethod method) {
        return (Http)this.setParam("method", method.name());
    }

    public Http url(String url) {
        return (Http)this.setParam("url", url);
    }

    public Http deliveryFrequency(int freq) {
        return (Http)this.setParam("delivery_frequency", String.valueOf(freq));
    }

    public Http maxSize(int max) {
        return (Http)this.setParam("max_size", String.valueOf(max));
    }

    public Http authType(AuthType auth) {
        return (Http)this.setParam("auth.type", auth.value());
    }

    public Http verifySSL(boolean trueOrFalse) {
        return (Http)this.setParam("verify_ssl", String.valueOf(trueOrFalse));
    }

    public Http useGzip(boolean trueOrFalse) {
        return (Http)this.setParam("use_gzip", String.valueOf(trueOrFalse));
    }

    public Http gzip() {
        return this.compression("gzip");
    }

    public Http zlib() {
        return this.compression("zlib");
    }

    public Http compression(String format) {
        return (Http)this.setParam("compression", format);
    }

    public Http auth(String username, String password) {
        return this.username(username).password(password);
    }

    public Http username(String username) {
        return (Http)this.setParam("auth.username", username);
    }

    public Http password(String password) {
        return (Http)this.setParam("auth.password", password);
    }

    @Override
    public Prepared parameters() {
        if (!(!"basic".equals(this.params.get("auth.type")) || this.params.has("auth.username") && this.params.has("auth.password"))) {
            throw new IllegalStateException("Username AND  password required if when the auth.type is basic");
        }
        return super.parameters();
    }

    public static class AuthType {
        private final String value;

        public AuthType(String value) {
            if (value == null || value.isEmpty()) {
                throw new IllegalArgumentException("Invalid auth type, cannot be null or empty");
            }
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum HttpFormat {
        JSON_META,
        JSON_ARRAY,
        JSON_NEW_LINE;


        public static HttpFormat fromStr(String str) {
            try {
                return HttpFormat.valueOf(str.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                return HttpFormat.valueOf(str);
            }
        }
    }
}

