/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.cli;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Parser {
    protected Parser() {
    }

    public static CliArguments parse(String[] args, List<CliSwitch> switches) {
        CliArguments res = new CliArguments(switches);
        String currentSwitch = null;
        String name = null;
        String value = null;
        if (args.length == 0) {
            System.out.println("There are no arguments passed.");
            return null;
        }
        for (String arg : args) {
            if (arg.indexOf(45) == 0) {
                if (currentSwitch != null) {
                    res.put(currentSwitch, name, value);
                    name = null;
                    value = null;
                }
                currentSwitch = arg;
                continue;
            }
            if (name == null) {
                name = arg;
                continue;
            }
            value = arg;
        }
        res.put(currentSwitch, name, value);
        for (CliSwitch s : switches) {
            if (s.isRequired() && res.get(s.shortForm) == null && res.map(s.shortForm) == null) {
                System.out.println(s.longForm + " - " + (s.message == null || s.message.isEmpty() ? " is a required parameter" : s.message));
                System.exit(0);
            }
            if (!s.hasDefault() || res.get(s.shortForm) != null) continue;
            res.put(s.shortForm, s.defaultName, s.defaultValue);
        }
        return res;
    }

    public static class CliArguments {
        protected List<CliSwitch> switches;
        protected Map<String, Object> res = new HashMap<String, Object>();

        public CliArguments(List<CliSwitch> switches) {
            this.switches = switches;
        }

        public void put(String currentSwitch, String name, String value) {
            if (currentSwitch.indexOf("--") == 0) {
                currentSwitch = currentSwitch.substring(2);
            }
            if (currentSwitch.indexOf("-") == 0) {
                currentSwitch = currentSwitch.substring(1);
            }
            HashMap val = this.res.get(currentSwitch);
            String shortForm = this.shortForm(currentSwitch);
            if (val == null && shortForm != null) {
                if (value != null) {
                    val = new HashMap();
                }
                this.res.put(shortForm, val);
            }
            if (value == null) {
                if (val instanceof Map) {
                    ((HashMap)val).put(name, value);
                } else {
                    this.res.put(currentSwitch, name);
                }
            } else if (val != null) {
                ((HashMap)val).put(name, value);
            }
        }

        public HashMap<String, String> map(String arg) {
            try {
                return (HashMap)this.res.get(this.shortForm(arg));
            }
            catch (ClassCastException cce) {
                return null;
            }
        }

        public String get(String arg) {
            try {
                return (String)this.res.get(this.shortForm(arg));
            }
            catch (ClassCastException cce) {
                return null;
            }
        }

        private String shortForm(String currentSwitch) {
            for (CliSwitch cliSwitch : this.switches) {
                if (!cliSwitch.shortForm.equalsIgnoreCase(currentSwitch) && !cliSwitch.longForm.equalsIgnoreCase(currentSwitch)) continue;
                return cliSwitch.shortForm;
            }
            return null;
        }
    }

    public static class CliSwitch {
        private final String message;
        private final boolean required;
        protected String shortForm;
        protected String longForm;
        private String defaultValue;
        private String defaultName;

        public CliSwitch(String shortForm, String longForm) {
            this(shortForm, longForm, false, "");
        }

        public CliSwitch(String shortForm, String longForm, boolean required, String message) {
            this.shortForm = shortForm;
            this.longForm = longForm;
            this.required = required;
            this.message = message;
        }

        public CliSwitch(String shortForm, String longForm, boolean required) {
            this(shortForm, longForm, required, "");
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setDefault(String defaultName) {
            this.setDefault(defaultName, null);
        }

        public void setDefault(String defaultName, String defaultVal) {
            this.defaultName = defaultName;
            this.defaultValue = defaultVal;
        }

        public boolean hasDefault() {
            return this.defaultValue != null || this.defaultName != null;
        }
    }
}

