/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.dynamiclist;

import com.datasift.client.BaseDataSiftResult;
import com.datasift.client.DataSiftApiClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.DataSiftResult;
import com.datasift.client.FutureData;
import com.datasift.client.dynamiclist.DynamicList;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.higgs.http.client.POST;
import io.higgs.http.client.Request;
import io.higgs.http.client.readers.PageReader;
import io.higgs.http.client.readers.Reader;
import java.net.URI;
import java.util.List;

public class DataSiftDynamicList
extends DataSiftApiClient {
    public static final String GET = "list/get";
    public static final String CREATE = "list/create";
    public static final String DELETE = "list/delete";
    public static final String EXISTS = "list/exists";
    public static final String ADD = "list/add";
    public static final String REMOVE = "list/remove";

    public DataSiftDynamicList(DataSiftConfig config) {
        super(config);
    }

    public FutureData<DataSiftResult> get() {
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(GET));
        Request request = this.config.http().GET(uri, (Reader)new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<DynamicList> create(ListType type, String name) {
        if (type == null || name == null) {
            throw new IllegalArgumentException("Type and name are both required");
        }
        FutureData<DynamicList> future = new FutureData<DynamicList>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(CREATE));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new DynamicList(), this.config))).form("type", (Object)type.toString()).form("name", (Object)name);
        this.performRequest(future, (Request)request);
        return future;
    }

    public FutureData<DataSiftResult> delete(DynamicList list) {
        if (list == null || list.getId() == null) {
            throw new IllegalArgumentException("Id is required");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(DELETE));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).form("id", (Object)list.getId());
        this.performRequest(future, (Request)request);
        return future;
    }

    public <T> FutureData<DataSiftResult> exists(DynamicList list, List<T> items) {
        if (list == null || list.getId() == null) {
            throw new IllegalArgumentException("Id and items are both required");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        ObjectMapper mapper = new ObjectMapper();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(EXISTS));
        try {
            POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).form("id", (Object)list.getId()).form("items", (Object)mapper.writeValueAsString(items));
            this.performRequest(future, (Request)request);
        }
        catch (JsonProcessingException e) {
            this.failNotify(future, e);
        }
        return future;
    }

    public <T> FutureData<DataSiftResult> add(DynamicList list, List<T> items) {
        if (list == null || list.getId() == null) {
            throw new IllegalArgumentException("Id and items are both required");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        ObjectMapper mapper = new ObjectMapper();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(ADD));
        try {
            POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).form("id", (Object)list.getId()).form("items", (Object)mapper.writeValueAsString(items));
            this.performRequest(future, (Request)request);
        }
        catch (JsonProcessingException e) {
            this.failNotify(future, e);
        }
        return future;
    }

    public <T> FutureData<DataSiftResult> remove(DynamicList list, List<T> items) {
        if (list == null || list.getId() == null) {
            throw new IllegalArgumentException("Id and items are both required");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        ObjectMapper mapper = new ObjectMapper();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(REMOVE));
        try {
            POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).form("id", (Object)list.getId()).form("items", (Object)mapper.writeValueAsString(items));
            this.performRequest(future, (Request)request);
        }
        catch (JsonProcessingException e) {
            this.failNotify(future, e);
        }
        return future;
    }

    public static enum ListType {
        STRING,
        INTEGER;


        public String toString() {
            switch (this) {
                case STRING: {
                    return "text";
                }
                case INTEGER: {
                    return "integer";
                }
            }
            return super.toString();
        }
    }
}

