/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client;

import io.netty.handler.codec.http.QueryStringEncoder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class ParamBuilder {
    protected Map<String, Object> params = new HashMap<String, Object>();

    public ParamBuilder put(String name, Object value) {
        this.params.put(name, value);
        return this;
    }

    public URI forURL(URI uri) {
        QueryStringEncoder encoder = new QueryStringEncoder(uri.toString());
        for (Map.Entry<String, Object> e : this.params.entrySet()) {
            encoder.addParam(e.getKey(), String.valueOf(e.getValue()));
        }
        try {
            return encoder.toUri();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot construct a query string from the given params. An invalid parameter was used.");
        }
    }

    public Map<String, Object> getParams() {
        return this.params;
    }
}

