/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client;

import com.datasift.client.DataSiftApiClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.FutureData;
import com.datasift.client.FutureResponse;
import com.datasift.client.accounts.DataSiftAccount;
import com.datasift.client.core.Balance;
import com.datasift.client.core.Dpu;
import com.datasift.client.core.Stream;
import com.datasift.client.core.Usage;
import com.datasift.client.core.Validation;
import com.datasift.client.historics.DataSiftHistorics;
import com.datasift.client.managedsource.DataSiftManagedSource;
import com.datasift.client.preview.DataSiftPreview;
import com.datasift.client.push.DataSiftPush;
import com.datasift.client.pylon.DataSiftPylon;
import com.datasift.client.stream.ConnectionManager;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import io.higgs.core.reflect.dependency.DependencyProvider;
import io.higgs.http.client.HttpRequestBuilder;
import io.higgs.http.client.POST;
import io.higgs.http.client.Request;
import io.higgs.http.client.readers.PageReader;
import io.higgs.http.client.readers.Reader;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class DataSiftClient
extends DataSiftApiClient {
    public static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final int DEFAULT_NUM = Integer.MIN_VALUE;
    protected DataSiftConfig config;
    protected DataSiftPylon pylon;
    protected DataSiftHistorics historics;
    protected DataSiftManagedSource source;
    protected DataSiftPreview preview;
    protected DataSiftPush push;
    protected ConnectionManager liveStream;
    protected DataSiftAccount account;
    public final String VALIDATE = "validate";
    public final String COMPILE = "compile";
    public final String BALANCE = "balance";
    public final String DPU = "dpu";
    public final String USAGE = "usage";

    public DataSiftClient() {
        this(new DataSiftConfig());
    }

    public DataSiftClient(DataSiftConfig config) {
        super(config);
        this.configureMapper();
        this.config = config;
        this.pylon = new DataSiftPylon(config);
        this.historics = new DataSiftHistorics(config);
        this.source = new DataSiftManagedSource(config);
        this.preview = new DataSiftPreview(config);
        this.push = new DataSiftPush(config);
        this.liveStream = new ConnectionManager(config);
        this.account = new DataSiftAccount(config);
        DependencyProvider.global().add(new Object[]{config});
    }

    protected void configureMapper() {
        MAPPER.setDateFormat((DateFormat)new SimpleDateFormat(DATE_FORMAT));
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.registerModule((Module)new JodaModule());
    }

    public DataSiftAccount account() {
        return this.account;
    }

    public DataSiftPylon pylon() {
        return this.pylon;
    }

    public DataSiftHistorics historics() {
        return this.historics;
    }

    public DataSiftManagedSource managedSource() {
        return this.source;
    }

    public DataSiftPreview preview() {
        return this.preview;
    }

    public DataSiftPush push() {
        return this.push;
    }

    public DataSiftConfig config() {
        return this.config;
    }

    public ConnectionManager liveStream() {
        return this.liveStream;
    }

    public FutureData<Validation> validate(String csdl) {
        FutureData<Validation> future = new FutureData<Validation>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("validate"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new Validation(), this.config))).form("csdl", (Object)csdl);
        this.performRequest(future, (Request)request);
        return future;
    }

    public FutureData<Stream> compile(String csdl) {
        FutureData<Stream> future = new FutureData<Stream>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("compile"));
        POST request = this.config.http().POST(uri, (Reader)new PageReader(this.newRequestCallback(future, new Stream(), this.config))).form("csdl", (Object)csdl);
        this.performRequest(future, (Request)request);
        return future;
    }

    public FutureData<Balance> balance() {
        FutureData<Balance> future = new FutureData<Balance>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("balance"));
        Request request = this.config.http().GET(uri, (Reader)new PageReader(this.newRequestCallback(future, new Balance(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<Dpu> dpu(Stream stream) {
        return this.dpu(FutureData.wrap(stream));
    }

    public FutureData<Dpu> dpu(FutureData<Stream> streamFuture) {
        final FutureData<Dpu> future = new FutureData<Dpu>();
        final Dpu dpu = new Dpu();
        FutureResponse<Stream> response = new FutureResponse<Stream>(){

            @Override
            public void apply(Stream stream) {
                URI uri = DataSiftClient.this.newParams().put("hash", stream.hash()).forURL(DataSiftClient.this.config.newAPIEndpointURI("dpu"));
                Request request = DataSiftClient.this.config.http().GET(uri, (Reader)new PageReader(DataSiftClient.this.newRequestCallback(future, dpu, DataSiftClient.this.config)));
                DataSiftClient.this.performRequest(future, request);
            }
        };
        this.unwrapFuture(streamFuture, future, dpu, response);
        return future;
    }

    public FutureData<Usage> usage() {
        return this.usage(Usage.Period.DAY);
    }

    public FutureData<Usage> usage(Usage.Period timePeriod) {
        String period;
        FutureData<Usage> future = new FutureData<Usage>();
        switch (timePeriod) {
            case HOUR: {
                period = "hour";
                break;
            }
            case CURRENT: {
                period = "current";
                break;
            }
            default: {
                period = "day";
            }
        }
        URI uri = this.newParams().put("period", period).forURL(this.config.newAPIEndpointURI("usage"));
        Request request = this.config.http().GET(uri, (Reader)new PageReader(this.newRequestCallback(future, new Usage(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public void shutdown() {
        HttpRequestBuilder.shutdown();
    }
}

